/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.utils;

import cn.sinozg.applet.common.exception.CavException;
import cn.sinozg.applet.common.utils.StringUtil;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.Validation;
import jakarta.validation.ValidatorFactory;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.util.ClassUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.DataBinder;
import org.springframework.validation.SmartValidator;
import org.springframework.validation.Validator;
import org.springframework.validation.beanvalidation.SpringValidatorAdapter;

public class VerifyUtil {
    private static jakarta.validation.Validator validator;
    private static SmartValidator validatorAdapter;
    private static final Logger LOG;

    private VerifyUtil() {
    }

    public static jakarta.validation.Validator getValidator() {
        return validator;
    }

    private static SmartValidator getValidatorAdapter(jakarta.validation.Validator validator) {
        if (validatorAdapter == null) {
            validatorAdapter = new SpringValidatorAdapter(validator);
        }
        return validatorAdapter;
    }

    public static <T> void validate(T t) {
        Set sets = validator.validate(t, new Class[0]);
        if (!sets.isEmpty()) {
            throw new ConstraintViolationException(sets);
        }
    }

    public static <T> void validate(T object, Class<?> ... groups) {
        Set sets = validator.validate(object, (Class[])groups);
        if (!sets.isEmpty()) {
            throw new ConstraintViolationException(sets);
        }
    }

    public static <T> void validateBySpring(T object, Class<?> ... groups) {
        String errors;
        DataBinder dataBinder = VerifyUtil.getBinder(object);
        if (groups != null) {
            dataBinder.validate((Object[])groups);
        }
        if (StringUtils.isNotEmpty((CharSequence)(errors = VerifyUtil.errorInfo(dataBinder.getBindingResult())))) {
            throw new CavException("BIZ000100014", new Object[]{errors});
        }
    }

    public static String errorInfo(BindingResult result) {
        if (result.hasErrors()) {
            return StringUtil.join(result.getAllErrors(), DefaultMessageSourceResolvable::getDefaultMessage);
        }
        return "";
    }

    private static <T> DataBinder getBinder(T object) {
        DataBinder dataBinder = new DataBinder(object, ClassUtils.getShortName(object.getClass()));
        dataBinder.setValidator((Validator)VerifyUtil.getValidatorAdapter(validator));
        return dataBinder;
    }

    static {
        LOG = LoggerFactory.getLogger(VerifyUtil.class);
        try (ValidatorFactory factory = ((HibernateValidatorConfiguration)((HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure()).failFast(true)).buildValidatorFactory();){
            validator = factory.getValidator();
        }
        catch (Exception e) {
            LOG.error("\u53c2\u6570\u6821\u9a8c\u521d\u59cb\u5316\u5931\u8d25\uff01", (Throwable)e);
        }
    }
}

