/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.common.utils;

import cn.sinozg.applet.common.core.model.I18nName;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;

/**
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2024
 * @since 2024-12-11 21:26
 */
public class I18nBaseUtil {

    protected static final Map<Locale, Function<I18nName, String>> LOCALE_MAP = new LinkedHashMap<>();

    static {
        LOCALE_MAP.put(Locale.CHINA, I18nName::getName);
        LOCALE_MAP.put(Locale.US, I18nName::getEnName);
        LOCALE_MAP.put(Locale.FRANCE, I18nName::getFrName);
        // 西班牙语
        LOCALE_MAP.put(new Locale("es", "ES"), I18nName::getEsName);
        LOCALE_MAP.put(Locale.JAPAN, I18nName::getJaName);
    }

    /**
     * 支持的语言
     * @return 语言
     */
    public static List<Locale> supportLocales(){
        List<Locale> locales = new ArrayList<>();
        LOCALE_MAP.forEach((k, v) -> locales.add(k));
        return locales;
    }
}
