/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.common.utils;

import cn.sinozg.applet.common.core.model.LoginUserVo;
import cn.sinozg.applet.common.exception.CavException;
import cn.sinozg.applet.common.service.FrameworkUserService;
import org.apache.commons.lang3.StringUtils;

import java.util.List;

/**
 * 用户信息
 * @Author: xyb
 * @Description:
 * @Date: 2022-11-14 下午 10:06
 **/
public class UserUtil {

    protected static final FrameworkUserService SERVICE = SpringUtil.getBean(FrameworkUserService.class);

    /**
     * 获取用户角色id信息
     * @return 角色集合
     */
    public static List<String> userRole (){
        return user().getRoles();
    }

    /**
     * 获取用户权限id
     * @return 权限集合
     */
    public static List<String> userPermission (){
        return user().getPermissions();
    }

    /**
     * 用户名称
     * @return 用户名称
     */
    public static String userName (){
        return user().getUserName();
    }

    /**
     * 获取部门名称
     * @return 部门名称
     */
    public static String deptName (){
        return user().getDeptName();
    }

    /**
     * 用户id 主键
     * @return 用户id 逻辑主键
     */
    public static String uid (){
        return user().getId();
    }

    /**
     * 刷新用户缓存
     */
    public static void refreshUser (){
        SERVICE.refreshUserInfo();
    }

    /**
     * 用户信息
     * @return 用户信息对象
     */
    public static LoginUserVo user (){
        return SERVICE.userInfo();
    }

    /**
     * 获取用户消息
     * @param token token
     * @param uid uid
     * @return 用户消息
     */
    public static LoginUserVo user (String token, String uid){
        return SERVICE.getUserInfo(token, uid);
    }

    /**
     * 获取租户id
     * @return 租户id
     */
    public static String tenantId () {
        return user().getTenantId();
    }

    /**
     * 获取到用户的时区
     *
     * @return 用户时区
     */
    public static String utc() {
        String utc = user().getTimeZone();
        if (StringUtils.isBlank(utc)) {
            throw new CavException("BIZ000100060");
        }
        return utc;
    }

}
