/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.common.core.base;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * 请求响应信息基类 分页返回
 * @Author: xyb
 * @Description: 
 * @Date: 2022-11-14 下午 09:35
 **/
public class BasePageResponse<T> extends BaseResponse<T> {
	/** 分页信息 */
	@JsonProperty("page")
	@Schema(description = "分页信息")
	private PagingResponse page;

	/**
	 * 获取 分页信息
	 *
	 * @return page 分页信息
	 */
	public PagingResponse getPage() {
		return this.page;
	}

	/**
	 * 设置 分页信息
	 *
	 * @param page 分页信息
	 */
	public void setPage(PagingResponse page) {
		this.page = page;
	}
}
