/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.common.core.base;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;


/**
 * 请求基类
 *
 * @Author: xyb
 * @Description:
 * @Date: 2022-11-14 下午 09:34
 **/
public class BaseRequest<T> {
    /** 请求参数 */
    @Valid
    @NotNull(message = "{TIRSCI.BaseRequest.params}")
    @Schema(description = "请求参数")
    private T params;

    /**
     * 获取 请求参数
     *
     * @return params 请求参数
     */
    public T getParams() {
      return this.params;
    }

    /**
     * 设置 请求参数
     *
     * @param params 请求参数
     */
    public void setParams(T params) {
      this.params = params;
    }
}
