/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.common.service.impl;

import cn.sinozg.applet.common.service.FrameworkAuthService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.stereotype.Service;
import org.springframework.web.servlet.HandlerInterceptor;

/**
 * 鉴权默认实现
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2024
 * @since 2024-01-05 17:29
 */
@Service
@ConditionalOnSingleCandidate(value = FrameworkAuthService.class)
public class DefaultFrameworkAuthServiceImpl implements FrameworkAuthService {
    @Override
    public String token() {
        return null;
    }

    @Override
    public String tokenWithException() {
        return null;
    }

    @Override
    public String loginId() {
        return null;
    }

    @Override
    public String loginIdByToken(String token) {
        return null;
    }

    @Override
    public String tokenById(String id) {
        return null;
    }

    @Override
    public void login(String id) {

    }

    @Override
    public void logout(String tokenId) {

    }

    @Override
    public void kickOutByTokenValue(String tokenId) {

    }

    @Override
    public long tokenTimeOut() {
        return 0;
    }

    @Override
    public HandlerInterceptor authInterceptor() {
        return null;
    }
}
