package cn.sinozg.applet.common.service.impl;

import cn.sinozg.applet.common.properties.AppValue;
import cn.sinozg.applet.common.service.PicService;
import jakarta.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.stereotype.Service;

/**
 * 图片接口默认实现
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2025
 * @since 2025-06-21 00:07
 */
@Service
@ConditionalOnSingleCandidate(value = PicService.class)
public class PicDefaultServiceImpl implements PicService {

    @Resource
    private AppValue app;

    @Override
    public String showUrl(String id) {
        if (StringUtils.isEmpty(id)) {
            return null;
        }
        String host = app.getFontUrl();
        if (StringUtils.contains(id, host)) {
            return id;
        }
        return host + id;
    }
}
