/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.core.model;

import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Objects;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.ECMultiplier;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.FixedPointCombMultiplier;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.Memoable;
import org.bouncycastle.util.Pack;

public class StandardSm2Engine {
    private final Digest digest;
    private final SM2Engine.Mode mode;
    private boolean forEncryption;
    private ECKeyParameters ecKey;
    private ECDomainParameters ecParams;
    private int curveLength;
    private SecureRandom random;

    public StandardSm2Engine() {
        this((Digest)new SM3Digest());
    }

    public StandardSm2Engine(SM2Engine.Mode mode) {
        this((Digest)new SM3Digest(), mode);
    }

    public StandardSm2Engine(Digest digest) {
        this(digest, SM2Engine.Mode.C1C2C3);
    }

    public StandardSm2Engine(Digest digest, SM2Engine.Mode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("mode cannot be NULL");
        }
        this.digest = digest;
        this.mode = mode;
    }

    public void init(boolean forEncryption, CipherParameters param) {
        this.forEncryption = forEncryption;
        if (forEncryption) {
            ParametersWithRandom rParam = (ParametersWithRandom)param;
            this.ecKey = (ECKeyParameters)rParam.getParameters();
            this.ecParams = this.ecKey.getParameters();
            ECPoint s = ((ECPublicKeyParameters)this.ecKey).getQ().multiply(this.ecParams.getH());
            if (s.isInfinity()) {
                throw new IllegalArgumentException("invalid key: [h]Q at infinity");
            }
            this.random = rParam.getRandom();
        } else {
            this.ecKey = (ECKeyParameters)param;
            this.ecParams = this.ecKey.getParameters();
        }
        this.curveLength = (this.ecParams.getCurve().getFieldSize() + 7) / 8;
    }

    public byte[] processBlock(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        if (this.forEncryption) {
            return this.encrypt(in, inOff, inLen);
        }
        return this.decrypt(in, inOff, inLen);
    }

    public int getOutputSize(int inputLen) {
        return 1 + 2 * this.curveLength + inputLen + this.digest.getDigestSize();
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }

    private byte[] encrypt(byte[] in, int inOff, int inLen) {
        ECPoint kpb;
        ECPoint c1P;
        byte[] c2 = new byte[inLen];
        System.arraycopy(in, inOff, c2, 0, c2.length);
        ECMultiplier multiplier = this.createBasePointMultiplier();
        do {
            BigInteger k = this.nextK();
            c1P = multiplier.multiply(this.ecParams.getG(), k).normalize();
            kpb = ((ECPublicKeyParameters)this.ecKey).getQ().multiply(k).normalize();
            this.kdf(this.digest, kpb, c2);
        } while (this.notEncrypted(c2, in, inOff));
        byte[] c3 = new byte[this.digest.getDigestSize()];
        this.addFieldElement(this.digest, kpb.getAffineXCoord());
        this.digest.update(in, inOff, inLen);
        this.addFieldElement(this.digest, kpb.getAffineYCoord());
        this.digest.doFinal(c3, 0);
        return this.convertToAsn1(c1P, c2, c3);
    }

    private byte[] decrypt(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        byte[] c2;
        byte[] originC3;
        byte[] c1;
        ECPoint c1P;
        byte[] decryptData = new byte[inLen];
        System.arraycopy(in, inOff, decryptData, 0, decryptData.length);
        try (ASN1InputStream aIn = new ASN1InputStream(decryptData);){
            ASN1Sequence seq;
            try {
                seq = (ASN1Sequence)aIn.readObject();
            }
            catch (IOException e) {
                throw new InvalidCipherTextException();
            }
            BigInteger x = ASN1Integer.getInstance((Object)seq.getObjectAt(0)).getValue();
            BigInteger y = ASN1Integer.getInstance((Object)seq.getObjectAt(1)).getValue();
            c1P = this.ecParams.getCurve().validatePoint(x, y);
            c1 = c1P.getEncoded(false);
            if (this.mode == SM2Engine.Mode.C1C3C2) {
                originC3 = ASN1OctetString.getInstance((Object)seq.getObjectAt(2)).getOctets();
                c2 = ASN1OctetString.getInstance((Object)seq.getObjectAt(3)).getOctets();
            } else {
                c2 = ASN1OctetString.getInstance((Object)seq.getObjectAt(2)).getOctets();
                originC3 = ASN1OctetString.getInstance((Object)seq.getObjectAt(3)).getOctets();
            }
        }
        catch (IOException e) {
            throw new InvalidCipherTextException();
        }
        ECPoint s = c1P.multiply(this.ecParams.getH());
        if (s.isInfinity()) {
            throw new InvalidCipherTextException("[h]C1 at infinity");
        }
        c1P = c1P.multiply(((ECPrivateKeyParameters)this.ecKey).getD()).normalize();
        this.kdf(this.digest, c1P, c2);
        byte[] c3 = new byte[this.digest.getDigestSize()];
        this.addFieldElement(this.digest, c1P.getAffineXCoord());
        this.digest.update(c2, 0, c2.length);
        this.addFieldElement(this.digest, c1P.getAffineYCoord());
        this.digest.doFinal(c3, 0);
        int check = 0;
        for (int i = 0; i != c3.length; ++i) {
            check |= c3[i] ^ originC3[i];
        }
        Arrays.fill(c1, (byte)0);
        Arrays.fill(c3, (byte)0);
        if (check != 0) {
            Arrays.fill(c2, (byte)0);
            throw new InvalidCipherTextException("invalid cipher text");
        }
        return c2;
    }

    private boolean notEncrypted(byte[] encData, byte[] in, int inOff) {
        for (int i = 0; i != encData.length; ++i) {
            if (encData[i] == in[inOff + i]) continue;
            return false;
        }
        return true;
    }

    private void kdf(Digest digest, ECPoint c1, byte[] encData) {
        int digestSize = digest.getDigestSize();
        byte[] buf = new byte[Math.max(4, digestSize)];
        int off = 0;
        Memoable memo = null;
        Memoable copy = null;
        if (digest instanceof Memoable) {
            Memoable m = (Memoable)digest;
            this.addFieldElement(digest, c1.getAffineXCoord());
            this.addFieldElement(digest, c1.getAffineYCoord());
            memo = m;
            copy = memo.copy();
        }
        int ct = 0;
        while (off < encData.length) {
            if (memo != null) {
                memo.reset(copy);
            } else {
                this.addFieldElement(digest, c1.getAffineXCoord());
                this.addFieldElement(digest, c1.getAffineYCoord());
            }
            Pack.intToBigEndian((int)(++ct), (byte[])buf, (int)0);
            digest.update(buf, 0, 4);
            digest.doFinal(buf, 0);
            int xorLen = Math.min(digestSize, encData.length - off);
            this.xor(encData, buf, off, xorLen);
            off += xorLen;
        }
    }

    private void xor(byte[] data, byte[] kdfOut, int dOff, int dRemaining) {
        for (int i = 0; i != dRemaining; ++i) {
            int n = dOff + i;
            data[n] = (byte)(data[n] ^ kdfOut[i]);
        }
    }

    private BigInteger nextK() {
        BigInteger k;
        int qBitLength = this.ecParams.getN().bitLength();
        while ((k = BigIntegers.createRandomBigInteger((int)qBitLength, (SecureRandom)this.random)).equals(BigIntegers.ZERO) || k.compareTo(this.ecParams.getN()) >= 0) {
        }
        return k;
    }

    private void addFieldElement(Digest digest, ECFieldElement v) {
        byte[] p = BigIntegers.asUnsignedByteArray((int)this.curveLength, (BigInteger)v.toBigInteger());
        digest.update(p, 0, p.length);
    }

    private byte[] convertToAsn1(ECPoint c1P, byte[] c2, byte[] c3) {
        ASN1Integer x = new ASN1Integer(c1P.getXCoord().toBigInteger());
        ASN1Integer y = new ASN1Integer(c1P.getYCoord().toBigInteger());
        DEROctetString derDig = new DEROctetString(c3);
        DEROctetString derEnc = new DEROctetString(c2);
        ASN1EncodableVector v = new ASN1EncodableVector();
        if (Objects.requireNonNull(this.mode) == SM2Engine.Mode.C1C3C2) {
            v.add((ASN1Encodable)x);
            v.add((ASN1Encodable)y);
            v.add((ASN1Encodable)derDig);
            v.add((ASN1Encodable)derEnc);
        } else {
            v.add((ASN1Encodable)x);
            v.add((ASN1Encodable)y);
            v.add((ASN1Encodable)derEnc);
            v.add((ASN1Encodable)derDig);
        }
        DERSequence seq = new DERSequence(v);
        try {
            return seq.getEncoded();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

