/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.utils;

import cn.sinozg.applet.common.config.SystemConfig;
import cn.sinozg.applet.common.core.model.DictDataVo;
import cn.sinozg.applet.common.core.model.I18nName;
import cn.sinozg.applet.common.enums.DictType;
import cn.sinozg.applet.common.holder.UserContextHolder;
import cn.sinozg.applet.common.utils.DictUtil;
import cn.sinozg.applet.common.utils.I18nBaseUtil;
import cn.sinozg.applet.common.utils.SpringUtil;
import cn.sinozg.applet.common.utils.WebUtil;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.MessageSource;
import org.springframework.web.servlet.LocaleResolver;

public class I18nUtil
extends I18nBaseUtil {
    private static final MessageSource MS = SpringUtil.getBean(MessageSource.class);
    private static final LocaleResolver LR = (LocaleResolver)SpringUtil.getBean("appletLocaleResolver");

    private I18nUtil() {
    }

    public static String getDictName(I18nName i18nName) {
        return I18nUtil.getDictName(i18nName, null);
    }

    public static String getDictName(DictDataVo cb) {
        return I18nUtil.getDictName(cb, null);
    }

    public static String getDictName(DictDataVo cb, Locale locale) {
        I18nName i18nName = cb.getI18nLabel();
        return I18nUtil.getDictName(i18nName, locale);
    }

    public static String getDictName(DictType type, String code) {
        return I18nUtil.getDictName(null, type, code);
    }

    public static String getDictName(Locale locale, DictType type, String code) {
        List<I18nName> list = I18nUtil.names(type, code);
        StringBuffer names = new StringBuffer();
        if (locale == null) {
            locale = UserContextHolder.getLocale();
        }
        if (CollectionUtils.isNotEmpty(list)) {
            for (I18nName n : list) {
                String temp;
                if (StringUtils.isNotBlank((CharSequence)names)) {
                    names.append(",");
                }
                if (!StringUtils.isNotBlank((CharSequence)(temp = I18nUtil.getDictName(n, locale)))) continue;
                names.append(temp);
            }
        }
        return names.toString();
    }

    public static String getDictName(DictType type, String code, String language) {
        Locale locale = new Locale(language);
        return I18nUtil.getDictName(locale, type, code);
    }

    public static String getDictName(I18nName i18nName, Locale locale) {
        if (i18nName == null) {
            return null;
        }
        if (locale == null) {
            locale = UserContextHolder.getLocale();
        }
        return I18nUtil.localeFunction(locale).apply(i18nName);
    }

    public static I18nName i18nName(DictType type, String code) {
        List<I18nName> list = I18nUtil.names(type, code);
        if (CollectionUtils.isNotEmpty(list)) {
            return list.get(0);
        }
        return null;
    }

    public static Map<String, I18nName> nameByType(DictType type) {
        HashMap<String, I18nName> map = new HashMap<String, I18nName>(64);
        List<DictDataVo> list = DictUtil.getDictCache(type);
        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(c -> map.put(c.getDictValue(), c.getI18nLabel()));
        }
        return map;
    }

    private static List<I18nName> names(DictType type, String code) {
        if (StringUtils.isBlank((CharSequence)code) || type == null) {
            return null;
        }
        Object[] codes = StringUtils.split((String)code, (String)",");
        Map<String, I18nName> map = I18nUtil.nameByType(type);
        if (ArrayUtils.isEmpty((Object[])codes) || MapUtils.isEmpty(map)) {
            return null;
        }
        ArrayList<I18nName> names = new ArrayList<I18nName>();
        for (Object c : codes) {
            names.add(map.get(c));
        }
        return names;
    }

    public static String locale() {
        Locale locale = UserContextHolder.getLocale();
        return locale.toString();
    }

    public static Function<I18nName, String> localeFunction(Locale locale) {
        if (!LOCALE_MAP.containsKey(locale)) {
            locale = Locale.CHINA;
        }
        return (Function)LOCALE_MAP.get(locale);
    }

    public static String propertyName(String propertyCode, Object ... params) {
        return I18nUtil.propertyName(null, propertyCode, params);
    }

    public static String propertyName(HttpServletRequest request, String propertyCode, Object ... params) {
        Locale locale;
        if (LR == null) {
            locale = Locale.getDefault();
        } else {
            if (request == null) {
                request = WebUtil.request();
            }
            locale = LR.resolveLocale(request);
        }
        return MS.getMessage(propertyCode, params, locale);
    }

    public static boolean isI18n() {
        return SystemConfig.APP.getLogin().isI18n();
    }
}

