/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.utils;

import cn.sinozg.applet.common.core.base.BasePageResponse;
import cn.sinozg.applet.common.core.base.BaseRequest;
import cn.sinozg.applet.common.core.base.BaseResponse;
import cn.sinozg.applet.common.core.base.ErrorInfo;
import cn.sinozg.applet.common.core.base.PagingRequest;
import cn.sinozg.applet.common.core.base.PagingResponse;
import cn.sinozg.applet.common.exception.CavException;
import cn.sinozg.applet.common.service.CipherService;
import cn.sinozg.applet.common.utils.I18nUtil;
import cn.sinozg.applet.common.utils.JsonUtil;
import cn.sinozg.applet.common.utils.SpringUtil;
import cn.sinozg.applet.common.utils.StringUtil;
import cn.sinozg.applet.common.utils.WebUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

public class MsgUtil {
    private static final Logger log = LoggerFactory.getLogger(MsgUtil.class);
    private static final CipherService CIPHER_SERVICE = SpringUtil.getBean(CipherService.class);

    private MsgUtil() {
    }

    public static <T> T params(BaseRequest<T> request) {
        T t = request.getParams();
        if (t == null) {
            throw new CavException("BIZ000100000");
        }
        return t;
    }

    public static <T> BaseResponse<T> ok(T params) {
        BaseResponse<T> response = new BaseResponse<T>();
        response.setData(params);
        return response;
    }

    public static BaseResponse<String> ok() {
        return new BaseResponse<String>();
    }

    public static <T, R> BasePageResponse<List<T>> page(PagingRequest info, R r, BiFunction<Page<T>, R, IPage<T>> function) {
        BasePageResponse<List<List>> response = new BasePageResponse<List<List>>();
        if (info == null) {
            throw new CavException("BIZ000100001");
        }
        long pageSize = info.getPageSize();
        Page p = new Page(info.getPageNum().longValue(), pageSize);
        IPage<T> pageData = function.apply(p, r);
        PagingResponse page = new PagingResponse();
        page.setPageNum(pageData.getCurrent());
        page.setPages(pageData.getPages());
        page.setPageSize(pageSize);
        page.setTotalNum(pageData.getTotal());
        response.setPage(page);
        response.setData(pageData.getRecords());
        return response;
    }

    public static void httpError(HttpServletResponse response, HttpServletRequest request, Exception e, HttpStatus status, String code, Object ... params) {
        BaseResponse<String> result = MsgUtil.error(request, e, code, params);
        MsgUtil.writeJson(response, request, status, result);
    }

    public static void writeJson(HttpServletResponse response, HttpServletRequest request, HttpStatus status, Object data) {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json");
        if (status != null) {
            response.setStatus(status.value());
        }
        try (PrintWriter writer = response.getWriter();){
            Object o = CIPHER_SERVICE.encryptJson(request, data);
            writer.print(JsonUtil.toJson((Object)o));
        }
        catch (IOException ex) {
            log.error("response error", (Throwable)ex);
        }
    }

    public static BaseResponse<String> error(HttpServletRequest request, Exception e, String code, Object ... params) {
        return MsgUtil.error(request, e, false, code, params);
    }

    public static BaseResponse<String> error(HttpServletRequest request, Exception e, boolean debug, String code, Object ... params) {
        ImmutablePair<String, String> pair = MsgUtil.errorMsg(request, e, code, params);
        BaseResponse<String> response = new BaseResponse<String>();
        response.setBizStatus("01");
        ErrorInfo r = new ErrorInfo();
        r.setCode((String)pair.getKey());
        r.setMessage((String)pair.getValue());
        r.setUrl(request.getRequestURI());
        MsgUtil.log((String)pair.getValue(), e, request);
        if (debug) {
            r.setMessage(e.getMessage());
        }
        response.setErrorInfo(r);
        return response;
    }

    public static String error(HttpServletRequest request, CavException e) {
        if (request == null) {
            request = WebUtil.request();
        }
        return (String)MsgUtil.errorMsg(request, (Exception)e, e.getCode(), e.getParameters()).getValue();
    }

    private static ImmutablePair<String, String> errorMsg(HttpServletRequest request, Exception e, String code, Object ... params) {
        Throwable t;
        for (t = e; t != null && !(t instanceof CavException); t = t.getCause()) {
        }
        String c = code;
        Object[] ps = params;
        if (t != null) {
            CavException ce = (CavException)t;
            c = ce.getCode();
            ps = ce.getParameters();
        }
        String propertyName = I18nUtil.propertyName(request, c, ps);
        return ImmutablePair.of((Object)c, (Object)propertyName);
    }

    private static void log(String localMessage, Exception ex, HttpServletRequest request) {
        if (ex == null) {
            return;
        }
        log.error("************************\u5f02\u5e38\u5f00\u59cb*******************************");
        log.error("\u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)request.getRequestURL());
        Object requestParams = request.getAttribute("Whj-Params");
        if (Objects.nonNull(requestParams)) {
            log.error("\u8bf7\u6c42\u53c2\u6570: {}", (Object)StringUtil.compressJson(requestParams.toString()));
        }
        if (ex instanceof CavException) {
            CavException e = (CavException)ex;
            Object[] os = Arrays.stream(e.getParameters()).filter(Objects::nonNull).toArray();
            log.error("Error : {} {} {}", new Object[]{e.getCode(), localMessage, ArrayUtils.toString((Object)os)});
        }
        log.error("Error DETAIL : ", (Throwable)ex);
        MsgUtil.printCause(ex.getCause(), ex.getStackTrace());
        log.error("************************\u5f02\u5e38\u7ed3\u675f*******************************");
    }

    public static void printCause(Throwable cause, StackTraceElement[] pste) {
        if (cause != null) {
            MsgUtil.printCause(cause.getStackTrace());
            MsgUtil.printCause(cause.getCause(), null);
        } else {
            MsgUtil.printCause(pste);
        }
    }

    private static void printCause(StackTraceElement[] ste) {
        if (ArrayUtils.isNotEmpty((Object[])ste)) {
            log.error("Cause by: {}", (Object)ste[0].toString());
        }
    }
}

