/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.service.impl;

import cn.sinozg.applet.common.core.model.RequestParameterEncrypt;
import cn.sinozg.applet.common.service.CipherService;
import cn.sinozg.applet.common.utils.SmUtil;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(prefix="app.sign", name={"crypto-type"}, havingValue="sm")
public class CipherSmServiceImpl
implements CipherService {
    private static final Logger log = LoggerFactory.getLogger(CipherSmServiceImpl.class);

    @Override
    public String encoder(CharSequence plainText) {
        return SmUtil.encryptSm3(plainText.toString());
    }

    @Override
    public boolean matches(CharSequence plainText, String encodedPassword) {
        return SmUtil.matchesSm3(plainText.toString(), encodedPassword);
    }

    @Override
    public boolean signature(boolean sha2, String signature, String ... params) {
        if (StringUtils.isBlank((CharSequence)signature)) {
            log.error("\u975e\u6cd5\u8bf7\u6c42\u53c2\u6570\uff0c\u7b7e\u540d\u53c2\u6570\u4e3a\u7a7a : {}", (Object)signature);
            return false;
        }
        if (StringUtils.isAnyEmpty((CharSequence[])params)) {
            log.error("\u975e\u6cd5\u8bf7\u6c42\u53c2\u6570\uff0c\u6709\u90e8\u5206\u53c2\u6570\u4e3a\u7a7a : {}", (Object)Arrays.toString(params));
            return false;
        }
        Arrays.sort(params);
        String source = StringUtils.join((Object[])params);
        return signature.equals(SmUtil.encryptSm3(source));
    }

    @Override
    public byte[] decryptJson(String content, String asymmetricPrivateKey, String symmetricEncrypt) throws Exception {
        String symmetricKey = SmUtil.decryptSm2(symmetricEncrypt, asymmetricPrivateKey);
        return SmUtil.decryptSm4(content, symmetricKey);
    }

    @Override
    public RequestParameterEncrypt encrypt(String content, String asymmetricPublicKey) throws Exception {
        String symmetricPrivateKey = SmUtil.generateKeySm4();
        String json = SmUtil.encryptSm4(content, symmetricPrivateKey);
        String symmetricEncrypt = SmUtil.encryptSm2(symmetricPrivateKey, asymmetricPublicKey);
        RequestParameterEncrypt encrypt = new RequestParameterEncrypt();
        encrypt.setData(json);
        encrypt.setSymmetricEncrypt(symmetricEncrypt);
        return encrypt;
    }
}

