/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.utils;

import cn.sinozg.applet.common.core.model.I18nName;
import cn.sinozg.applet.common.utils.FileUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class I18nBaseUtil {
    private static final Map<Locale, Function<I18nName, String>> LOCALE_MAP = new LinkedHashMap<Locale, Function<I18nName, String>>();
    private static List<Locale> SUPPORT_LOCALES;

    public static List<Locale> supportLocales() {
        if (SUPPORT_LOCALES == null) {
            SUPPORT_LOCALES = I18nBaseUtil.webSupport();
        }
        return SUPPORT_LOCALES;
    }

    protected static Map<Locale, Function<I18nName, String>> supportLocaleMap() {
        if (MapUtils.isEmpty(LOCALE_MAP)) {
            Map<Locale, Function<I18nName, String>> map = I18nBaseUtil.baseLocals();
            List<Locale> locales = I18nBaseUtil.supportLocales();
            for (Map.Entry<Locale, Function<I18nName, String>> e : map.entrySet()) {
                if (!locales.contains(e.getKey())) continue;
                LOCALE_MAP.put(e.getKey(), e.getValue());
            }
        }
        return LOCALE_MAP;
    }

    private static List<Locale> webSupport() {
        Set fileNames = FileUtil.resourcesFile((String)"classpath*:i18n/**/*.*", (String)"messages");
        ArrayList<Locale> list = new ArrayList<Locale>();
        if (CollectionUtils.isNotEmpty((Collection)fileNames)) {
            for (String fileName : fileNames) {
                String name = StringUtils.substringBefore((String)fileName, (String)".");
                String[] ns = StringUtils.split((String)name, (String)"_");
                Locale locale = new Locale(ns[1], ns[2]);
                list.add(locale);
            }
        }
        return list;
    }

    private static Map<Locale, Function<I18nName, String>> baseLocals() {
        LinkedHashMap<Locale, Function<I18nName, String>> localMap = new LinkedHashMap<Locale, Function<I18nName, String>>();
        localMap.put(Locale.CHINA, I18nName::getName);
        localMap.put(Locale.US, I18nName::getEnName);
        localMap.put(Locale.FRANCE, I18nName::getFrName);
        localMap.put(new Locale("es", "ES"), I18nName::getEsName);
        localMap.put(new Locale("ru", "RU"), I18nName::getRuName);
        localMap.put(Locale.JAPAN, I18nName::getJaName);
        return localMap;
    }
}

