/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.utils;

import cn.sinozg.applet.common.config.SystemConfig;
import cn.sinozg.applet.common.core.model.IpAddressInfo;
import cn.sinozg.applet.common.core.model.UserAgentInfo;
import cn.sinozg.applet.common.utils.HttpUtil;
import cn.sinozg.applet.common.utils.JsonUtil;
import cn.sinozg.applet.common.utils.RedisUtil;
import cn.sinozg.applet.common.utils.ServiceEnums;
import cn.sinozg.applet.common.utils.StringUtil;
import cn.sinozg.applet.common.utils.WebUtil;
import com.blueconic.browscap.Capabilities;
import jakarta.servlet.http.HttpServletRequest;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsUtil {
    private static final Logger log = LoggerFactory.getLogger(OsUtil.class);
    public static final String IP_URL = "https://whois.pconline.com.cn/ipJson.jsp?ip=%s&json=true";
    private static final String UNKNOWN = "Unknown";
    private static final String LOCAL_HOST = "127.0.0.1";

    private OsUtil() {
    }

    public static boolean isWindows() {
        ServiceEnums service = ServiceEnums.serviceEnums();
        return service == ServiceEnums.WIN;
    }

    public static String realAddressByIp(String ip) {
        String ipKey = String.format("jby:biz:ip:%s", Strings.CS.replace(ip, ".", "_"));
        String location = (String)RedisUtil.getCacheObject(ipKey);
        if (StringUtils.isBlank((CharSequence)location)) {
            location = OsUtil.getRealAddressByIp(ip);
            RedisUtil.setCacheObject(ipKey, location, Duration.ofDays(7L));
        }
        return location;
    }

    public static String getRealAddressByIp(String ip) {
        if (OsUtil.internalIp(ip)) {
            return "\u5185\u7f51IP";
        }
        try {
            byte[] bs = HttpUtil.getBytes((String)String.format(IP_URL, ip));
            IpAddressInfo address = null;
            if (bs != null) {
                String rspStr = new String(bs, Charset.forName("GBK"));
                address = (IpAddressInfo)JsonUtil.toPojo((String)rspStr, IpAddressInfo.class);
            }
            if (address == null) {
                log.error("\u8fdc\u7a0b\u83b7\u53d6\u5730\u7406\u4f4d\u7f6e\u5f02\u5e38 {}", (Object)ip);
                return UNKNOWN;
            }
            String location = StringUtils.isAllBlank((CharSequence[])new CharSequence[]{address.getPro(), address.getCity()}) ? address.getAddr() : (Strings.CS.equals(address.getPro(), address.getCity()) ? address.getPro() : String.format("%s %s", address.getPro(), address.getCity()));
            return StringUtils.trim((String)location);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5730\u7406\u4f4d\u7f6e\u5f02\u5e38 {}", (Object)ip);
            return UNKNOWN;
        }
    }

    public static String getIpAddr() {
        return OsUtil.getIpAddr(WebUtil.request());
    }

    public static String getIpAddr(HttpServletRequest request) {
        CharSequence[] ips;
        String unknown = UNKNOWN;
        if (request == null) {
            return unknown;
        }
        String[] headers = new String[]{"x-forwarded-for", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_Client_IP", "HTTP_X_FORWARDED_FOR"};
        String ip = null;
        int max = headers.length + 1;
        for (int i = 0; i < max && (StringUtils.isEmpty(ip) || unknown.equalsIgnoreCase(ip)); ++i) {
            ip = i == headers.length ? request.getRemoteAddr() : request.getHeader(headers[i]);
        }
        int maxLen = 15;
        if (StringUtils.isNotEmpty(ip) && ip.length() > maxLen) {
            ip = StringUtils.substringBefore((String)ip, (String)",");
        }
        if (Strings.CS.equalsAny((CharSequence)ip, ips = new String[]{LOCAL_HOST, "0:0:0:0:0:0:0:1"})) {
            ip = OsUtil.getHostIp();
        }
        return ip;
    }

    public static boolean internalIp(String ip) {
        byte[] addr = OsUtil.textToNumericFormatV4(ip);
        return OsUtil.internalIp(addr) || LOCAL_HOST.equals(ip);
    }

    public static ImmutablePair<List<String>, List<String>> ipAndMacAddress() throws Exception {
        List<InetAddress> list = OsUtil.getLocalAllInetAddress();
        List<String> ip = OsUtil.address(list, InetAddress::getHostAddress);
        List<String> mac = OsUtil.address(list, OsUtil::getMacByInetAddress);
        return ImmutablePair.of(ip, mac);
    }

    public static ImmutablePair<String, String> cpuAndMainBoardSerial() throws Exception {
        ServiceEnums enums = ServiceEnums.serviceEnums();
        String cpu = OsUtil.serialNo(enums, true);
        String mainBoard = OsUtil.serialNo(enums, false);
        return ImmutablePair.of((Object)cpu, (Object)mainBoard);
    }

    public static String getHostIp() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            log.error("\u83b7\u53d6ip\u5730\u5740\u5931\u8d25:{}", (Object)e.getMessage());
            return LOCAL_HOST;
        }
    }

    public static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            log.error("\u83b7\u53d6host name\u5931\u8d25:{}", (Object)e.getMessage());
            return UNKNOWN;
        }
    }

    public static UserAgentInfo userAgent(HttpServletRequest request) {
        UserAgentInfo agent = new UserAgentInfo();
        String userAgent = request.getHeader("User-Agent");
        Capabilities capabilities = SystemConfig.PARSER.parse(userAgent);
        agent.setBrowser(OsUtil.formatUserAgent(capabilities.getBrowser(), capabilities.getBrowserMajorVersion()));
        agent.setPlatform(OsUtil.formatUserAgent(capabilities.getPlatform(), capabilities.getPlatformVersion()));
        return agent;
    }

    private static String formatUserAgent(String name, String version) {
        CharSequence[] searchStrings = new String[]{"0", UNKNOWN};
        if (Strings.CS.equalsAny((CharSequence)version, searchStrings)) {
            return name;
        }
        return String.format("%s(%s)", name, version);
    }

    public static byte[] textToNumericFormatV4(String src) {
        byte[] res = new byte[4];
        long tmpValue = 0L;
        int currByte = 0;
        boolean newOctet = true;
        int len = src.length();
        int ipLen = 15;
        if (len == 0 || len > ipLen) {
            return null;
        }
        for (int i = 0; i < len; ++i) {
            char c = src.charAt(i);
            if (c == '.') {
                if (newOctet || tmpValue < 0L || tmpValue > 255L || currByte == 3) {
                    return null;
                }
                res[currByte++] = (byte)(tmpValue & 0xFFL);
                tmpValue = 0L;
                newOctet = true;
                continue;
            }
            int digit = Character.digit(c, 10);
            if (digit < 0) {
                return null;
            }
            tmpValue *= 10L;
            tmpValue += (long)digit;
            newOctet = false;
        }
        int min = 4;
        int max = 8;
        if (newOctet || tmpValue < 0L || tmpValue >= 1L << (min - currByte) * max) {
            return null;
        }
        res[currByte] = (byte)(tmpValue >> 24 - 8 * currByte & 0xFFL);
        return res;
    }

    public static String getMacByInetAddress(InetAddress inetAddr) {
        try {
            byte[] mac = NetworkInterface.getByInetAddress(inetAddr).getHardwareAddress();
            StringBuilder info = new StringBuilder();
            for (byte b : mac) {
                String temp = Integer.toHexString(b & 0xFF);
                if (temp.length() == 1) {
                    info.append("0");
                }
                info.append(temp);
                info.append("-");
            }
            StringUtil.delLast(info);
            return info.toString().toUpperCase();
        }
        catch (SocketException e) {
            log.error("\u83b7\u53d6\u7f51\u7edc\u63a5\u53e3\u7684Mac\u5730\u5740\u9519\u8bef {}", (Object)inetAddr);
            return null;
        }
    }

    private static boolean internalIp(byte[] addr) {
        int internalLength = 2;
        if (ArrayUtils.isEmpty((byte[])addr) || addr.length < internalLength) {
            return true;
        }
        byte b0 = addr[0];
        byte b1 = addr[1];
        int section01 = 10;
        int section02 = -84;
        int section03 = 16;
        int section04 = 31;
        int section05 = -64;
        int section06 = -88;
        switch (b0) {
            case 10: {
                return true;
            }
            case -84: {
                if (b1 >= 16 && b1 <= 31) {
                    return true;
                }
            }
            case -64: {
                if (b1 != -88) break;
                return true;
            }
        }
        return false;
    }

    private static String serialNo(ServiceEnums enums, boolean cpu) throws Exception {
        String info;
        String command = cpu ? enums.getCpuCommand() : enums.getMbCommand();
        String substr = cpu ? enums.getCpuKey() : enums.getMbKey();
        Integer index = enums.getIndex();
        Process process = Runtime.getRuntime().exec(command);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            Stream<Object> stream = Stream.empty();
            if (index != null) {
                stream = reader.lines().skip(index.intValue());
            } else if (StringUtils.isNotBlank((CharSequence)substr)) {
                stream = reader.lines().filter(line -> line.contains(substr)).map(line -> StringUtils.substringBefore((String)line, (String)":"));
            }
            info = stream.findFirst().orElse("").trim();
        }
        if (cpu && enums.getCpuHandle() != null) {
            info = enums.getCpuHandle().apply(info);
        }
        return info;
    }

    private static List<String> address(List<InetAddress> list, Function<InetAddress, String> map) {
        List result = null;
        if (CollectionUtils.isNotEmpty(list)) {
            result = list.stream().map(map).distinct().map(String::toUpperCase).collect(Collectors.toList());
        }
        return result;
    }

    private static List<InetAddress> getLocalAllInetAddress() throws Exception {
        ArrayList<InetAddress> result = new ArrayList<InetAddress>();
        Enumeration<NetworkInterface> nie = NetworkInterface.getNetworkInterfaces();
        while (nie.hasMoreElements()) {
            NetworkInterface ni = nie.nextElement();
            Enumeration<InetAddress> iae = ni.getInetAddresses();
            while (iae.hasMoreElements()) {
                InetAddress ia = iae.nextElement();
                if (ia.isLoopbackAddress() || ia.isLinkLocalAddress() || ia.isMulticastAddress()) continue;
                result.add(ia);
            }
        }
        return result;
    }
}

