/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.common.core.base;

import io.swagger.v3.oas.annotations.media.Schema;


/**
 * 请求基类
 * 分页使用
 * @Author: xyb
 * @Description:
 * @Date: 2022-11-14 下午 09:34
 **/
public class BasePageRequest<T> extends BaseRequest<T> {
    /** 分页对象 */
    @Schema(description = "分页对象")
    private PagingRequest page;

    /**
     * 获取 分页对象
     *
     * @return page 分页对象
     */
    public PagingRequest getPage() {
      return this.page;
    }

    /**
     * 设置 分页对象
     *
     * @param page 分页对象
     */
    public void setPage(PagingRequest page) {
      this.page = page;
    }
}
