/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.common.core.model;

import io.swagger.v3.oas.annotations.media.Schema;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

/**
* 登录用户身份权限 信息
 * 缓存在redis里面
* @Author: xyb
* @Description:
* @Date: 2022-11-14 下午 09:40
**/
public class LoginUserVo {

    /** 用户ID */
    @Schema(description = "用户ID")
    private String id;
    /** 腾讯传过来的id */
    @Schema(description = "腾讯传过来的id")
    private String userId;

    /** 部门ID */
    @Schema(description = "部门ID")
    private String deptId;
    /** 部门名称 */
    @Schema(description = "部门名称")
    private String deptName;

    /** 用户账号 */
    @Schema(description = "用户账号")
    private String userName;

    /** 用户昵称 */
    @Schema(description = "用户昵称")
    private String nickName;

    /** 用户类型;00系统用户 11:企业微信用户 */
    @Schema(description = "用户类型;00系统用户 11:企业微信用户")
    private String userType;

    /** 用户邮箱 */
    @Schema(description = "用户邮箱")
    private String email;

    /** 手机号码 */
    @Schema(description = "手机号码")
    private String phoneNumber;

    /** 用户性别;0男 1女 2未知 */
    @Schema(description = "用户性别;00男 01女 02未知")
    private String sex;

    /** 头像地址 */
    @Schema(description = "头像地址")
    private String avatar;

    /** 最后登陆IP */
    @Schema(description = "最后登陆IP")
    private String loginIp;


    /** 最后登陆时间 */
    @Schema(description = "最后登陆时间")
    private LocalDateTime loginDate;
    /** openId */
    @Schema(description = "openId")
    private String openId;

    /** 权限列表 */
    private List<String> permissions;
    /** 角色id集合 */
    private List<String> roles;
    /** 租户id */
    @Schema(description = "租户id")
    private String tenantId;
    @Schema(description = "用户时区")
    private String timeZone;
    /** 角色信息 */
    @Schema(description = "角色信息")
    private List<RoleInfoVo> roleInfos;

    /** 其他的参数 */
    @Schema(description = "其他的参数")
    private Map<String, Object> other;

    /**
     * 获取 用户ID
     *
     * @return id 用户ID
     */
    public String getId() {
        return this.id;
    }

    /**
     * 设置 用户ID
     *
     * @param id 用户ID
     */
    public void setId(String id) {
        this.id = id;
    }

    /**
     * 获取 腾讯传过来的id
     *
     * @return userId 腾讯传过来的id
     */
    public String getUserId() {
        return this.userId;
    }

    /**
     * 设置 腾讯传过来的id
     *
     * @param userId 腾讯传过来的id
     */
    public void setUserId(String userId) {
        this.userId = userId;
    }

    /**
     * 获取 部门ID
     *
     * @return deptId 部门ID
     */
    public String getDeptId() {
        return this.deptId;
    }

    /**
     * 设置 部门ID
     *
     * @param deptId 部门ID
     */
    public void setDeptId(String deptId) {
        this.deptId = deptId;
    }

    /**
     * 获取 部门名称
     *
     * @return deptName 部门名称
     */
    public String getDeptName() {
        return this.deptName;
    }

    /**
     * 设置 部门名称
     *
     * @param deptName 部门名称
     */
    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    /**
     * 获取 用户账号
     *
     * @return userName 用户账号
     */
    public String getUserName() {
        return this.userName;
    }

    /**
     * 设置 用户账号
     *
     * @param userName 用户账号
     */
    public void setUserName(String userName) {
        this.userName = userName;
    }

    /**
     * 获取 用户昵称
     *
     * @return nickName 用户昵称
     */
    public String getNickName() {
        return this.nickName;
    }

    /**
     * 设置 用户昵称
     *
     * @param nickName 用户昵称
     */
    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    /**
     * 获取 用户类型;00系统用户 11:企业微信用户
     *
     * @return userType 用户类型;00系统用户 11:企业微信用户
     */
    public String getUserType() {
        return this.userType;
    }

    /**
     * 设置 用户类型;00系统用户 11:企业微信用户
     *
     * @param userType 用户类型;00系统用户 11:企业微信用户
     */
    public void setUserType(String userType) {
        this.userType = userType;
    }

    /**
     * 获取 用户邮箱
     *
     * @return email 用户邮箱
     */
    public String getEmail() {
        return this.email;
    }

    /**
     * 设置 用户邮箱
     *
     * @param email 用户邮箱
     */
    public void setEmail(String email) {
        this.email = email;
    }

    /**
     * 获取 手机号码
     *
     * @return phoneNumber 手机号码
     */
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    /**
     * 设置 手机号码
     *
     * @param phoneNumber 手机号码
     */
    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    /**
     * 获取 用户性别;0男 1女 2未知
     *
     * @return sex 用户性别;0男 1女 2未知
     */
    public String getSex() {
        return this.sex;
    }

    /**
     * 设置 用户性别;0男 1女 2未知
     *
     * @param sex 用户性别;0男 1女 2未知
     */
    public void setSex(String sex) {
        this.sex = sex;
    }

    /**
     * 获取 头像地址
     *
     * @return avatar 头像地址
     */
    public String getAvatar() {
        return this.avatar;
    }

    /**
     * 设置 头像地址
     *
     * @param avatar 头像地址
     */
    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    /**
     * 获取 最后登陆IP
     *
     * @return loginIp 最后登陆IP
     */
    public String getLoginIp() {
        return this.loginIp;
    }

    /**
     * 设置 最后登陆IP
     *
     * @param loginIp 最后登陆IP
     */
    public void setLoginIp(String loginIp) {
        this.loginIp = loginIp;
    }

    /**
     * 获取 最后登陆时间
     *
     * @return loginDate 最后登陆时间
     */
    public LocalDateTime getLoginDate() {
        return this.loginDate;
    }

    /**
     * 设置 最后登陆时间
     *
     * @param loginDate 最后登陆时间
     */
    public void setLoginDate(LocalDateTime loginDate) {
        this.loginDate = loginDate;
    }

    /**
     * 获取 openId
     *
     * @return openId openId
     */
    public String getOpenId() {
        return this.openId;
    }

    /**
     * 设置 openId
     *
     * @param openId openId
     */
    public void setOpenId(String openId) {
        this.openId = openId;
    }

    /**
     * 获取 权限列表
     *
     * @return permissions 权限列表
     */
    public List<String> getPermissions() {
        return this.permissions;
    }

    /**
     * 设置 权限列表
     *
     * @param permissions 权限列表
     */
    public void setPermissions(List<String> permissions) {
        this.permissions = permissions;
    }

    /**
     * 获取 角色id集合
     *
     * @return roles 角色id集合
     */
    public List<String> getRoles() {
        return this.roles;
    }

    /**
     * 设置 角色id集合
     *
     * @param roles 角色id集合
     */
    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    /**
     * 获取 租户id
     *
     * @return tenantId 租户id
     */
    public String getTenantId() {
        return this.tenantId;
    }

    /**
     * 设置 租户id
     *
     * @param tenantId 租户id
     */
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getTimeZone() {
        return timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    /**
     * 获取 角色信息
     *
     * @return roleInfos 角色信息
     */
    public List<RoleInfoVo> getRoleInfos() {
        return this.roleInfos;
    }

    /**
     * 设置 角色信息
     *
     * @param roleInfos 角色信息
     */
    public void setRoleInfos(List<RoleInfoVo> roleInfos) {
        this.roleInfos = roleInfos;
    }

    /**
     * 获取 其他的参数
     *
     * @return other 其他的参数
     */
    public Map<String, Object> getOther() {
        return this.other;
    }

    /**
     * 设置 其他的参数
     *
     * @param other 其他的参数
     */
    public void setOther(Map<String, Object> other) {
        this.other = other;
    }
}
