/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.common.properties;

import cn.sinozg.applet.common.constant.BaseConstants;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * 自定义项目配置
 * @Author: xyb
 * @Description:
 * @Date: 2022-11-14 下午 09:42
 **/
@Component
@ConfigurationProperties(prefix = BaseConstants.APP_PREFIX)
public class AppValue {

    /** 前端显示图片的前缀 */
    private String fontUrl;

    /** debug 模式 */
    private Boolean debug;
    /** swagger 配置 */
    private SwaggerValue swagger;

    /** 登录设置 */
    private LoginValue login;

    /** 微信设置 */
    private WechatValue wechat;

    /** 拦截器 **/
    private ApiUrlValue apiUrl;

    /** 租户 */
    private TenantValue tenant;

    /** 参数签名 */
    private SignValue sign;
    /** 证书地址 */
    private CrtValue crt;

    /** 日志打印 */
    private SpyValue spy;
    /** 文件存储 兼容多个  */
    private OssValue oss;

    /**
     * 获取 swagger 配置
     *
     * @return swagger swagger 配置
     */
    public SwaggerValue getSwagger() {
        return this.swagger;
    }

    /**
     * 设置 swagger 配置
     *
     * @param swagger swagger 配置
     */
    public void setSwagger(SwaggerValue swagger) {
        this.swagger = swagger;
    }

    /**
     * 获取 前端显示图片的前缀
     *
     * @return fontUrl 前端显示图片的前缀
     */
    public String getFontUrl() {
        return this.fontUrl;
    }

    /**
     * 设置 前端显示图片的前缀
     *
     * @param fontUrl 前端显示图片的前缀
     */
    public void setFontUrl(String fontUrl) {
        this.fontUrl = fontUrl;
    }

    /**
     * 获取 debug 模式
     *
     * @return debug 模式
     */
    public Boolean getDebug() {
        return debug;
    }

    /**
     * 设置 debug 模式
     *
     * @param debug debug 模式
     */
    public void setDebug(Boolean debug) {
        this.debug = debug;
    }

    /**
     * 获取 登录设置
     *
     * @return login 登录设置
     */
    public LoginValue getLogin() {
        return this.login;
    }

    /**
     * 设置 登录设置
     *
     * @param login 登录设置
     */
    public void setLogin(LoginValue login) {
        this.login = login;
    }

    /**
     * 获取 微信设置
     *
     * @return wechat 微信设置
     */
    public WechatValue getWechat() {
        return this.wechat;
    }

    /**
     * 设置 微信设置
     *
     * @param wechat 微信设置
     */
    public void setWechat(WechatValue wechat) {
        this.wechat = wechat;
    }

    /**
     * 获取 拦截器
     *
     * @return apiUrl 拦截器
     */
    public ApiUrlValue getApiUrl() {
        return this.apiUrl;
    }

    /**
     * 设置 拦截器
     *
     * @param apiUrl 拦截器
     */
    public void setApiUrl(ApiUrlValue apiUrl) {
        this.apiUrl = apiUrl;
    }

    /**
     * 获取 租户
     *
     * @return tenant 租户
     */
    public TenantValue getTenant() {
        return this.tenant;
    }

    /**
     * 设置 租户
     *
     * @param tenant 租户
     */
    public void setTenant(TenantValue tenant) {
        this.tenant = tenant;
    }

    /**
     * 获取 参数签名
     *
     * @return sign 参数签名
     */
    public SignValue getSign() {
        return this.sign;
    }

    /**
     * 设置 参数签名
     *
     * @param sign 参数签名
     */
    public void setSign(SignValue sign) {
        this.sign = sign;
    }


    /**
     * 获取 证书地址
     *
     * @return crt 证书地址
     */
    public CrtValue getCrt() {
        return this.crt;
    }

    /**
     * 设置 证书地址
     *
     * @param crt 证书地址
     */
    public void setCrt(CrtValue crt) {
        this.crt = crt;
    }

    /**
     * 获取 sql日志参数
     *
     * @return spy sql日志参数
     */
    public SpyValue getSpy() {
        return spy;
    }

    /**
     * 设置 sql日志参数
     *
     * @param spy sql日志参数
     */
    public void setSpy(SpyValue spy) {
        this.spy = spy;
    }

    /**
     * 获取 文件存储
     *
     * @return oss 文件存储
     */
    public OssValue getOss() {
        return oss;
    }
    /**
     * 设置 文件存储
     *
     * @param oss 文件存储
     */
    public void setOss(OssValue oss) {
        this.oss = oss;
    }
}
