/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.common.properties;

/**
 * 参数是否加密
 * @Author: xyb
 * @Description:
 * @Date: 2023-04-21 下午 05:49
 **/
public class SignValue {
    /** 参数签名 */
    private boolean signEnable;
    /** 签名随机数时间 默认 60s*/
    private int signExpTime = 60;
    /** 参数是否加密 */
    private boolean cryptoEnable;
    /** 加密类型： rsaRse sm */
    private String cryptoType;
    /** 公钥 */
    private String privateKey;
    /** 私钥 */
    private String publicKey;

    /**
     * 获取 参数签名
     *
     * @return signEnable 参数签名
     */
    public boolean isSignEnable() {
        return this.signEnable;
    }

    /**
     * 设置 参数签名
     *
     * @param signEnable 参数签名
     */
    public void setSignEnable(boolean signEnable) {
        this.signEnable = signEnable;
    }

    /**
     * 获取 签名随机数时间 默认 60s
     *
     * @return signExpTime 签名随机数时间 默认 60s
     */
    public int getSignExpTime() {
        return this.signExpTime;
    }

    /**
     * 设置 签名随机数时间 默认 60s
     *
     * @param signExpTime 签名随机数时间 默认 60s
     */
    public void setSignExpTime(int signExpTime) {
        this.signExpTime = signExpTime;
    }

    /**
     * 获取 参数是否加密
     *
     * @return cryptoEnable 参数是否加密
     */
    public boolean isCryptoEnable() {
        return this.cryptoEnable;
    }

    /**
     * 设置 参数是否加密
     *
     * @param cryptoEnable 参数是否加密
     */
    public void setCryptoEnable(boolean cryptoEnable) {
        this.cryptoEnable = cryptoEnable;
    }

    public String getCryptoType() {
        return cryptoType;
    }

    public void setCryptoType(String cryptoType) {
        this.cryptoType = cryptoType;
    }

    /**
     * 获取 公钥
     *
     * @return privateKey 公钥
     */
    public String getPrivateKey() {
        return this.privateKey;
    }

    /**
     * 设置 公钥
     *
     * @param privateKey 公钥
     */
    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    /**
     * 获取 私钥
     *
     * @return publicKey 私钥
     */
    public String getPublicKey() {
        return this.publicKey;
    }

    /**
     * 设置 私钥
     *
     * @param publicKey 私钥
     */
    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }
}