/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.common.service;

import org.springframework.web.servlet.HandlerInterceptor;

/**
 * 鉴权
 * @Description
 * @Copyright Copyright (c) 2024
 * @author xieyubin
 * @since 2024-01-05 17:03:03
 */
public interface FrameworkAuthService {

    /**
     * 获取到token 无异常
     * @return token
     */
    String token ();

    /**
     * 获取到token 不处理异常
     * @return token
     */
    String tokenWithException ();

    /**
     * 当前登录id 无异常
     * @return 登录id
     */
    String loginId ();

    /**
     * 通过token 等到当前用户id
     * @param token token
     * @return 登录id
     */
    String loginIdByToken(String token);

    /**
     * 通过登录id获取到token
     * @param id 登录id
     * @return token
     */
    String tokenById (String id);

    /**
     * 登录后处理
     * @param id 登录id
     */
    void login(String id);

    /**
     * 登出
     * @param tokenId token
     */
    void logout(String tokenId);

    /**
     * 强制登出
     * @param tokenId token
     */
    void kickOutByTokenValue(String tokenId);

    /**
     * token 失效时间
     * @return 失效时间
     */
    long tokenTimeOut();

    /**
     * 获取权限拦截器
     * @return 拦截器
     */
    HandlerInterceptor authInterceptor();
}
