/*
 * Copyright (C) 2020-2025, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.common.service;

import org.springframework.web.servlet.config.annotation.InterceptorRegistry;

/**
 * 用户自定义的 拦截器<br/>
 * 逻辑：实现类上的可以加上注解 @Order <br/>
 * order 小于100的在默认参数拦截器 权限拦截器之前执行
 * @Description
 * @Copyright Copyright (c) 2025
 * @author xyb
 * @since 2025-03-23 21:56:51
*/
public interface FrameworkInterceptorService {

    /**
     * 项目自定义的拦截器
     * @param registry InterceptorRegistry对象
     */
    default void addInterceptor(InterceptorRegistry registry) {}
}
