/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.common.service;

import cn.sinozg.applet.common.core.model.LoginUserVo;

/**
 * 系统登录鉴权 用户信息接口
 * @Author: xyb
 * @Description:
 * @Date: 2022-11-14 下午 09:44
 **/
public interface FrameworkUserService {

    /**
     * 强刷用户信息缓存
     * @return 用户信息
     */
    LoginUserVo refreshUserInfo();

    /**
     * 缓存里面获取到用户信息
     * @return 用户信息
     */
    LoginUserVo userInfo ();

    /**
     * 设置用户信息到缓存里面
     * @param token token
     * @param uid 用户id
     * @param user 用户信息
     * @return 用户信息
     */
    LoginUserVo setUserInfo (String token, String uid, LoginUserVo user);

    /**
     * 获取用户信息到缓存里面
     * @param token token
     * @param uid 用户id
     * @return 用户信息
     */
    LoginUserVo getUserInfo (String token, String uid);
}
