/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.common.utils;

import cn.sinozg.applet.common.core.base.BasePageResponse;
import cn.sinozg.applet.common.core.base.PagingRequest;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.util.List;

/**
* <p>封装分页信息</p>
 * <pre> {@code
* PageUtil<ResponseData, RequestData> pu = (p, q) -> mapper.pageList(p, q);
* BasePageResponse<List<ResponseData>> result = pu.page(request.getPage(), params);
* }</pre>
 * @Author: xyb
* @Description: 
* @Date: 2022-11-14 下午 10:04
**/
@FunctionalInterface
public interface PageUtil<T, R> {

	/**
	 *  封装分页对象
	 * @param info 分页对象
	 * @param r 参数
	 * @return 查询集合
	 */
    default BasePageResponse<List<T>> page(PagingRequest info, R r){
        return MsgUtil.page(info, r, this::queryPage);
    }

    /**
     * 获取数据集合
     * @param page 分页对象
     * @param r 参数
     * @return 结果集
     */
    IPage<T> queryPage(Page<T> page, R r);
}
