/*
 * Copyright (C) 2020-2025, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.common.utils;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;

import java.util.function.Function;

/**
 * 服务器类型
 * @Description
 * @Copyright Copyright (c) 2025
 * @author xyb
 * @since 2025-03-25 16:04:09
*/
enum ServiceEnums {

    /** windows */
    WIN("windows", "wmic cpu get ProcessorId", "wmic baseboard get serialnumber", 2),
    /** MAC OS macos 没有cpu 序列号，取硬件的uuid */
    MAC_OS ("mac", "system_profiler SPHardwareDataType", "Hardware UUID", "Serial Number"),
    /** Linux */
    LINUX("linux", "dmidecode -t processor | grep 'ID'", "ID", "dmidecode |grep 'Serial Number'", "Serial Number", null, s -> Strings.CS.replace(s, StringUtils.SPACE, StringUtils.EMPTY)),
    ;
    /** 编号 */
    private final String code;
    /** cpu 指令 */
    private final String cpuCommand;
    /** cpu 关键字 */
    private final String cpuKey;
    /** 主板 指令 */
    private final String mbCommand;
    /** 主板 关键字 */
    private final String mbKey;
    /** 数据下标 */
    private final Integer index;
    /** cpu 数据处理 */
    private final Function<String, String> cpuHandle;

    ServiceEnums(String code, String cpuCommand, String mbCommand, int index) {
        this(code, cpuCommand, null, mbCommand, null, index, null);
    }

    ServiceEnums(String code, String command, String cpuKey, String mbKey) {
        this(code, command, cpuKey, command, mbKey, null, null);
    }
    ServiceEnums(String code, String cpuCommand, String cpuKey, String mbCommand, String mbKey, Integer index, Function<String, String> cpuHandle){
        this.code = code;
        this.cpuCommand = cpuCommand;
        this.cpuKey = cpuKey;
        this.mbCommand = mbCommand;
        this.mbKey = mbKey;
        this.index = index;
        this.cpuHandle = cpuHandle;
    }

    public String getCode() {
        return code;
    }

    public String getCpuCommand() {
        return cpuCommand;
    }

    public String getCpuKey() {
        return cpuKey;
    }

    public String getMbCommand() {
        return mbCommand;
    }

    public String getMbKey() {
        return mbKey;
    }

    public Integer getIndex() {
        return index;
    }

    public Function<String, String> getCpuHandle() {
        return cpuHandle;
    }

    public static ServiceEnums serviceEnums(){
        String osName = System.getProperty("os.name").toLowerCase();
        for (ServiceEnums value : values()) {
            if (Strings.CS.startsWith(osName, value.getCode())) {
                return value;
            }
        }
        return LINUX;
    }
}
