/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.config;

import cn.sinozg.applet.common.utils.DateUtil;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.impl.LaissezFaireSubTypeValidator;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class JacksonConfig {
    @Bean
    public JsonMapper jsonMapper() {
        JsonMapper jsonMapper = (JsonMapper)JsonMapper.builder().build();
        JacksonConfig.initConfig(jsonMapper, false, true, true);
        return jsonMapper;
    }

    public static void mapperConfig(JsonMapper jsonMapper) {
        JacksonConfig.initConfig(jsonMapper, true, true, true);
    }

    public static void initConfig(JsonMapper jsonMapper, boolean config, boolean simple, boolean date) {
        JacksonConfig.initConfig(jsonMapper, config, simple, date, false);
    }

    public static void initConfig(JsonMapper jsonMapper, boolean config, boolean simple, boolean date, boolean disableUnknown) {
        if (config) {
            JacksonConfig.initConfigModule(jsonMapper);
        }
        if (simple) {
            JacksonConfig.initSimpleModule(jsonMapper);
        }
        if (date) {
            JacksonConfig.initDateModule(jsonMapper);
        }
        jsonMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, disableUnknown);
    }

    private static void initConfigModule(JsonMapper jm) {
        jm.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        jm.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        jm.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        jm.activateDefaultTyping((PolymorphicTypeValidator)LaissezFaireSubTypeValidator.instance, ObjectMapper.DefaultTyping.NON_FINAL, JsonTypeInfo.As.WRAPPER_ARRAY);
    }

    private static void initSimpleModule(JsonMapper jsonMapper) {
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addSerializer(Long.class, (JsonSerializer)ToStringSerializer.instance);
        simpleModule.addSerializer(Long.TYPE, (JsonSerializer)ToStringSerializer.instance);
        simpleModule.addSerializer(Long.TYPE, (JsonSerializer)ToStringSerializer.instance);
        simpleModule.addSerializer(BigDecimal.class, (JsonSerializer)ToStringSerializer.instance);
        jsonMapper.registerModule((Module)simpleModule);
        jsonMapper.enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
    }

    private static void initDateModule(JsonMapper jsonMapper) {
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        javaTimeModule.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(DateUtil.formatter((String)"yyyy-MM-dd HH:mm:ss")));
        javaTimeModule.addSerializer(LocalDate.class, (JsonSerializer)new LocalDateSerializer(DateUtil.formatter((String)"yyyy-MM-dd")));
        javaTimeModule.addSerializer(LocalTime.class, (JsonSerializer)new LocalTimeSerializer(DateUtil.formatter((String)"HH:mm:ss")));
        javaTimeModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(DateUtil.formatter((String)"yyyy-MM-dd HH:mm:ss")));
        javaTimeModule.addDeserializer(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer(DateUtil.formatter((String)"yyyy-MM-dd")));
        javaTimeModule.addDeserializer(LocalTime.class, (JsonDeserializer)new LocalTimeDeserializer(DateUtil.formatter((String)"HH:mm:ss")));
        jsonMapper.registerModule((Module)javaTimeModule).registerModule((Module)new ParameterNamesModule());
    }
}

