/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.utils;

import cn.sinozg.applet.common.utils.PojoUtil;
import cn.sinozg.applet.common.utils.SpringUtil;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.Strings;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.support.atomic.RedisAtomicLong;

public class RedisUtil {
    protected static final RedisTemplate<String, Object> REDIS_TEMPLATE = (RedisTemplate)SpringUtil.getBean("objRedisTemplate");
    protected static final RedisTemplate<String, String> STRING_REDIS_TEMPLATE = (RedisTemplate)SpringUtil.getBean("stringRedisTemplate");

    public static <T> void setCacheObject(String key, T value) {
        REDIS_TEMPLATE.opsForValue().set((Object)key, value);
    }

    public static <T> void setCacheObject(String key, T value, long timeout, TimeUnit timeUnit) {
        if (timeout > 0L) {
            REDIS_TEMPLATE.opsForValue().set((Object)key, value, timeout, timeUnit);
        } else {
            REDIS_TEMPLATE.opsForValue().set((Object)key, value);
        }
    }

    public static <T> void setCacheObject(String key, T value, long timeout) {
        RedisUtil.setCacheObject(key, value, timeout, TimeUnit.SECONDS);
    }

    public static <T> void setCacheObject(String key, T value, Duration duration) {
        RedisUtil.setCacheObject(key, value, duration.getSeconds(), TimeUnit.SECONDS);
    }

    public static <T> void setCacheObjectBatch(Map<String, T> data, Function<String, String> fun, Duration duration) {
        RedisSerializer keySerializer = REDIS_TEMPLATE.getStringSerializer();
        RedisSerializer serializer = (RedisSerializer)PojoUtil.cast((Object)REDIS_TEMPLATE.getValueSerializer());
        REDIS_TEMPLATE.executePipelined(connection -> {
            data.forEach((k, v) -> connection.stringCommands().set(Objects.requireNonNull(keySerializer.serialize((Object)(fun == null ? k : (String)fun.apply((String)k)))), Objects.requireNonNull(serializer.serialize(v)), Expiration.from((Duration)duration), RedisStringCommands.SetOption.UPSERT));
            return null;
        }, serializer);
    }

    public static <T> boolean setIfAbsentObject(String key, T value, Duration duration) {
        return Boolean.TRUE.equals(REDIS_TEMPLATE.opsForValue().setIfAbsent((Object)key, value, duration.getSeconds(), TimeUnit.SECONDS));
    }

    public static boolean expire(String key, long timeout) {
        return RedisUtil.expire(key, timeout, TimeUnit.SECONDS);
    }

    public static boolean expire(String key, Duration duration) {
        return RedisUtil.expire(key, duration.getSeconds(), TimeUnit.SECONDS);
    }

    public static boolean expire(String key, long timeout, TimeUnit unit) {
        return Boolean.TRUE.equals(REDIS_TEMPLATE.expire((Object)key, timeout, unit));
    }

    public static Long objExpireTime(String key) {
        return REDIS_TEMPLATE.getExpire((Object)key);
    }

    public static <T> T getCacheObject(String key) {
        Object o = REDIS_TEMPLATE.opsForValue().get((Object)key);
        return (T)PojoUtil.cast((Object)o);
    }

    public static <T> List<T> cacheByPipelined(List<String> keyList) {
        RedisSerializer keySerializer = REDIS_TEMPLATE.getStringSerializer();
        RedisSerializer serializer = (RedisSerializer)PojoUtil.cast((Object)REDIS_TEMPLATE.getValueSerializer());
        List list = REDIS_TEMPLATE.executePipelined(connection -> {
            keyList.forEach(k -> connection.stringCommands().get(Objects.requireNonNull(keySerializer.serialize(k))));
            return null;
        }, serializer);
        return (List)PojoUtil.cast((Object)list);
    }

    public static boolean deleteObject(String key) {
        return Boolean.TRUE.equals(REDIS_TEMPLATE.delete((Object)key));
    }

    public static boolean deleteKeys(String key) {
        Set keys;
        Object pattern = key;
        if (!Strings.CS.endsWith((CharSequence)key, (CharSequence)"*")) {
            pattern = key + "*";
        }
        if (CollectionUtils.isNotEmpty((Collection)(keys = REDIS_TEMPLATE.keys(pattern)))) {
            return RedisUtil.deleteObject(keys) > 0L;
        }
        return true;
    }

    public static long deleteObject(Collection<String> collection) {
        Long l = REDIS_TEMPLATE.delete(collection);
        if (l != null) {
            return l;
        }
        return 0L;
    }

    public static long getIncr(String key, Duration duration) {
        return RedisUtil.getIncr(key, duration, () -> 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getIncr(String key, Duration duration, Supplier<Long> supplier) {
        String string = key.intern();
        synchronized (string) {
            RedisAtomicLong ai = new RedisAtomicLong(key, Objects.requireNonNull(REDIS_TEMPLATE.getConnectionFactory()));
            long count = ai.getAndIncrement();
            if (duration != null) {
                ai.expire(duration.getSeconds(), TimeUnit.SECONDS);
            }
            if (count == 0L) {
                ai.set(supplier.get() + 1L);
                count = ai.getAndIncrement();
            }
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long setIncr(String key, long value) {
        String string = key.intern();
        synchronized (string) {
            RedisAtomicLong ai = new RedisAtomicLong(key, Objects.requireNonNull(REDIS_TEMPLATE.getConnectionFactory()));
            ai.set(value);
            return ai.getAndIncrement();
        }
    }

    public static <T> void setCacheMap(String key, Map<String, T> dataMap) {
        if (dataMap != null) {
            REDIS_TEMPLATE.opsForHash().putAll((Object)key, dataMap);
        }
    }

    public static <T> Map<String, T> getCacheMap(String key) {
        Map map = REDIS_TEMPLATE.opsForHash().entries((Object)key);
        return (Map)PojoUtil.cast((Object)map);
    }

    public static void mapPut(String key, String hashKey, Object value) {
        REDIS_TEMPLATE.opsForHash().put((Object)key, (Object)hashKey, value);
    }

    public static <T> T mapGet(String key, String hashKey) {
        Object v = REDIS_TEMPLATE.opsForHash().get((Object)key, (Object)hashKey);
        return (T)PojoUtil.cast((Object)v);
    }

    public static void mapRemove(String key, Object ... hashKey) {
        REDIS_TEMPLATE.opsForHash().delete((Object)key, hashKey);
    }

    public static Collection<String> keys(String pattern) {
        return REDIS_TEMPLATE.keys((Object)pattern);
    }

    public static Boolean setCacheSet(String key, String value, double score) {
        return REDIS_TEMPLATE.opsForZSet().add((Object)key, (Object)value, score);
    }

    public static Long removeRangeCacheSet(String key, long start, long end) {
        return REDIS_TEMPLATE.opsForZSet().removeRange((Object)key, start, end);
    }

    public static Long removeCacheSet(String key, Object ... value) {
        return REDIS_TEMPLATE.opsForZSet().remove((Object)key, value);
    }

    public static Set<ZSetOperations.TypedTuple<String>> rangeWithScore(String key, long start, long end) {
        return STRING_REDIS_TEMPLATE.opsForZSet().rangeWithScores((Object)key, start, end);
    }

    public static Set<ZSetOperations.TypedTuple<String>> sortRangeWithScoresCacheSet(String key, double min, double max) {
        return STRING_REDIS_TEMPLATE.opsForZSet().rangeByScoreWithScores((Object)key, min, max);
    }
}

