/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.utils;

import java.util.function.Function;
import org.apache.commons.lang3.Strings;

enum ServiceEnums {
    WIN("windows", "wmic cpu get ProcessorId", "wmic baseboard get serialnumber", 2),
    MAC_OS("mac", "system_profiler SPHardwareDataType", "Hardware UUID", "Serial Number"),
    LINUX("linux", "dmidecode -t processor | grep 'ID'", "ID", "dmidecode |grep 'Serial Number'", "Serial Number", null, s -> Strings.CS.replace(s, " ", ""));

    private final String code;
    private final String cpuCommand;
    private final String cpuKey;
    private final String mbCommand;
    private final String mbKey;
    private final Integer index;
    private final Function<String, String> cpuHandle;

    private ServiceEnums(String code, String cpuCommand, String mbCommand, int index) {
        this(code, cpuCommand, null, mbCommand, null, index, null);
    }

    private ServiceEnums(String code, String command, String cpuKey, String mbKey) {
        this(code, command, cpuKey, command, mbKey, null, null);
    }

    private ServiceEnums(String code, String cpuCommand, String cpuKey, String mbCommand, String mbKey, Integer index, Function<String, String> cpuHandle) {
        this.code = code;
        this.cpuCommand = cpuCommand;
        this.cpuKey = cpuKey;
        this.mbCommand = mbCommand;
        this.mbKey = mbKey;
        this.index = index;
        this.cpuHandle = cpuHandle;
    }

    public String getCode() {
        return this.code;
    }

    public String getCpuCommand() {
        return this.cpuCommand;
    }

    public String getCpuKey() {
        return this.cpuKey;
    }

    public String getMbCommand() {
        return this.mbCommand;
    }

    public String getMbKey() {
        return this.mbKey;
    }

    public Integer getIndex() {
        return this.index;
    }

    public Function<String, String> getCpuHandle() {
        return this.cpuHandle;
    }

    public static ServiceEnums serviceEnums() {
        String osName = System.getProperty("os.name").toLowerCase();
        for (ServiceEnums value : ServiceEnums.values()) {
            if (!Strings.CS.startsWith((CharSequence)osName, (CharSequence)value.getCode())) continue;
            return value;
        }
        return LINUX;
    }
}

