/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.common.core.model;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

/**
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2025
 * @since 2025-07-01 23:26
 */
public class ErrorMsgInfo {

    private final String code;

    private final Exception exp;

    private final boolean debug;

    private final boolean printCause;

    private final HttpServletRequest request;

    private final HttpServletResponse response;

    private final Object[] params;

    private ErrorMsgInfo(String code, boolean debug, boolean print, Exception e, HttpServletRequest request, HttpServletResponse response, Object[] params){
        this.code = code;
        this.debug = debug;
        this.printCause = print;
        this.exp = e;
        this.request = request;
        this.response = response;
        this.params = params;
    }

    public static class Builder {

        private final String code;

        private final Exception e;

        private boolean debug;

        private boolean print;

        private final HttpServletRequest request;

        private HttpServletResponse response;

        private final Object[] params;

        public Builder(String code, HttpServletRequest request, HttpServletResponse response) {
            this(code, null, request, response);
        }

        public Builder(String code, Exception e, HttpServletRequest request, HttpServletResponse response) {
            this(code, e, request, response, (Object) null);
        }

        public Builder(String code, Exception e, HttpServletRequest request, Object ... params) {
            this(code, e, request, null, params);
        }

        public Builder(String code, Exception e, HttpServletRequest request, HttpServletResponse response, Object ... params) {
            this.code = code;
            this.e = e;
            this.request = request;
            this.response = response;
            this.params = params;
            this.debug = false;
            this.print = true;
        }

        public Builder response(HttpServletResponse response) {
            this.response = response;
            return this;
        }

        public Builder closeCause() {
            this.print = false;
            return this;
        }

        public Builder debug() {
            this.debug = true;
            return this;
        }

        public ErrorMsgInfo build() {
            return new ErrorMsgInfo(code, debug, print, e, request, response, params);
        }
    }

    public String getCode() {
        return code;
    }

    public Exception getExp() {
        return exp;
    }

    public boolean isDebug() {
        return debug;
    }

    public boolean isPrintCause() {
        return printCause;
    }

    public HttpServletRequest getRequest() {
        return request;
    }

    public HttpServletResponse getResponse() {
        return response;
    }

    public Object[] getParams() {
        return params;
    }
}
