/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.common.service.impl;

import cn.sinozg.applet.common.service.AuthStorageService;
import cn.sinozg.applet.common.utils.RedisUtil;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.stereotype.Service;

import java.util.Collection;
import java.util.concurrent.TimeUnit;

/**
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2025
 * @since 2025-07-18 12:14
 */
@Service
@ConditionalOnSingleCandidate(AuthStorageService.class)
public class AuthStorageDefaultServiceImpl implements AuthStorageService {

    @Override
    public <T> T getCacheObject(String key) {
        return RedisUtil.getCacheObject(key);
    }

    @Override
    public void setCacheObject(String key, Object value, long timeout) {
        RedisUtil.setCacheObject(key, value, timeout);
    }

    @Override
    public void deleteObject(String key) {
        RedisUtil.deleteObject(key);
    }

    @Override
    public long objExpireTime(String key) {
        return RedisUtil.objExpireTime(key);
    }

    @Override
    public void expire(String key, long timeout, TimeUnit unit) {
        RedisUtil.expire(key, timeout, unit);
    }

    @Override
    public Collection<String> keys(String pattern) {
        return RedisUtil.keys(pattern);
    }
}
