/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.common.service.impl;

import cn.sinozg.applet.common.service.FrameworkTenantService;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.stereotype.Service;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;

/**
 * 租户
 * @Description
 * @Copyright Copyright (c) 2024
 * @author xyb
 * @since 2024-11-03 14:37:44
*/
@Service
@ConditionalOnSingleCandidate(value = FrameworkTenantService.class)
public class DefaultFrameworkTenantService implements FrameworkTenantService {

    @Override
    public void dbInterceptor(MybatisPlusInterceptor interceptor) {
    }

    @Override
    public void expiredCheckInterceptor(InterceptorRegistry interceptor) {
    }
}
