/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.config;

import cn.sinozg.applet.common.core.ThreadFun;
import cn.sinozg.applet.common.handler.ThreadPoolExecutorHandler;
import cn.sinozg.applet.common.utils.ThreadPool;
import com.alibaba.ttl.threadpool.TtlExecutors;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.springframework.aop.interceptor.AsyncUncaughtExceptionHandler;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.AsyncConfigurer;
import org.springframework.scheduling.annotation.EnableAsync;

@EnableAsync
@Configuration
public class ThreadPoolConfig
implements AsyncConfigurer {
    public Executor getAsyncExecutor() {
        return TtlExecutors.getTtlExecutorService((ExecutorService)new ThreadPoolExecutorHandler("system_async_pool"));
    }

    public AsyncUncaughtExceptionHandler getAsyncUncaughtExceptionHandler() {
        return super.getAsyncUncaughtExceptionHandler();
    }

    @Bean(name={"scheduledExecutorService"})
    protected ScheduledExecutorService scheduledExecutorService() {
        return new ScheduledThreadPoolExecutor(ThreadFun.CORE_POOL_SIZE, ThreadFun.threadFactory((String)"schedule-pool")){

            @Override
            protected void afterExecute(Runnable r, Throwable t) {
                super.afterExecute(r, t);
                ThreadPool.printException((Runnable)r, (Throwable)t);
            }
        };
    }
}

