/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.core.model;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

public class ErrorMsgInfo {
    private final String code;
    private final Exception exp;
    private final boolean debug;
    private final boolean printCause;
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final Object[] params;

    private ErrorMsgInfo(String code, boolean debug, boolean print, Exception e, HttpServletRequest request, HttpServletResponse response, Object[] params) {
        this.code = code;
        this.debug = debug;
        this.printCause = print;
        this.exp = e;
        this.request = request;
        this.response = response;
        this.params = params;
    }

    public String getCode() {
        return this.code;
    }

    public Exception getExp() {
        return this.exp;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isPrintCause() {
        return this.printCause;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public Object[] getParams() {
        return this.params;
    }

    public static class Builder {
        private final String code;
        private final Exception e;
        private boolean debug;
        private boolean print;
        private final HttpServletRequest request;
        private HttpServletResponse response;
        private final Object[] params;

        public Builder(String code, HttpServletRequest request, HttpServletResponse response) {
            this(code, (Exception)null, request, response);
        }

        public Builder(String code, Exception e, HttpServletRequest request, HttpServletResponse response) {
            this(code, e, request, response, new Object[]{null});
        }

        public Builder(String code, Exception e, HttpServletRequest request, Object ... params) {
            this(code, e, request, null, params);
        }

        public Builder(String code, Exception e, HttpServletRequest request, HttpServletResponse response, Object ... params) {
            this.code = code;
            this.e = e;
            this.request = request;
            this.response = response;
            this.params = params;
            this.debug = false;
            this.print = true;
        }

        public Builder response(HttpServletResponse response) {
            this.response = response;
            return this;
        }

        public Builder closeCause() {
            this.print = false;
            return this;
        }

        public Builder debug() {
            this.debug = true;
            return this;
        }

        public ErrorMsgInfo build() {
            return new ErrorMsgInfo(this.code, this.debug, this.print, this.e, this.request, this.response, this.params);
        }
    }
}

