/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.runner;

import cn.sinozg.applet.common.utils.SpringUtil;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.scheduling.support.CronTrigger;

public abstract class BaseScheduling
implements SchedulingConfigurer {
    protected String cron;
    @Deprecated
    protected Class<? extends BaseScheduling> clazz;

    public abstract void setParams();

    public abstract void execute();

    public void configureTasks(@NotNull ScheduledTaskRegistrar registrar) {
        this.initParams();
        Class<BaseScheduling> runClass = this.clazz != null ? this.clazz : this.getClass();
        BaseScheduling thisObj = SpringUtil.getBean(runClass);
        registrar.addTriggerTask(thisObj::execute, trigger -> {
            this.initParams();
            CronTrigger ct = new CronTrigger(this.cron);
            return ct.nextExecution(trigger);
        });
    }

    private void initParams() {
        this.setParams();
        if (StringUtils.isBlank((CharSequence)this.cron)) {
            throw new RuntimeException("\u8bf7\u5148\u8bbe\u7f6ecron\u53c2\u6570\uff01");
        }
    }
}

