/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.utils;

import cn.sinozg.applet.common.exception.CavException;
import cn.sinozg.applet.common.function.ConsumerException;
import cn.sinozg.applet.common.utils.FileUtil;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DowUtil {
    private static final Logger log = LoggerFactory.getLogger(DowUtil.class);

    private DowUtil() {
    }

    public static void download(HttpServletResponse response, String fileName, byte[] bs, Consumer<BufferedOutputStream> consumer) {
        DowUtil.downloadExp(response, fileName, bs, (ConsumerException<BufferedOutputStream>)((ConsumerException)bos -> {
            if (consumer != null) {
                consumer.accept((BufferedOutputStream)bos);
            }
        }));
    }

    public static void downloadExp(HttpServletResponse response, String fileName, byte[] bs, ConsumerException<BufferedOutputStream> consumer) {
        if (StringUtils.isNotBlank((CharSequence)fileName)) {
            DowUtil.setResponse(response, fileName, bs);
        }
        try (ServletOutputStream os = response.getOutputStream();
             BufferedOutputStream bos = new BufferedOutputStream((OutputStream)os);){
            if (bs != null) {
                bos.write(bs);
            }
            if (consumer != null) {
                consumer.accept((Object)bos);
            }
        }
        catch (Exception e) {
            log.error("\u4e0b\u8f7d\u8d44\u6e90\u9519\u8bef\u3002", (Throwable)e);
            throw new CavException("BIZ000100023");
        }
    }

    public static void setResponse(HttpServletResponse response, String fileName, byte[] bs) {
        String charset = StandardCharsets.UTF_8.name();
        response.reset();
        response.setCharacterEncoding(charset);
        response.setHeader("Content-Encoding", charset);
        response.setContentType(FileUtil.fileType((String)fileName));
        if (bs != null) {
            response.setIntHeader("Content-Length", bs.length);
        }
        response.setHeader("Content-Disposition", "attachment;filename=" + FileUtil.encodeName((String)fileName, (String)charset));
    }
}

