/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.utils;

import cn.sinozg.applet.common.utils.PojoUtil;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class WebUtil {
    private static final Logger log = LoggerFactory.getLogger(WebUtil.class);

    private WebUtil() {
    }

    public static HttpServletRequest request() {
        ServletRequestAttributes attributes = WebUtil.attributes();
        if (attributes != null) {
            return attributes.getRequest();
        }
        return null;
    }

    public static HttpServletResponse response() {
        return WebUtil.attributes().getResponse();
    }

    public static <T> T getAttribute(String name) {
        HttpServletRequest request = WebUtil.request();
        if (request != null) {
            return (T)PojoUtil.cast((Object)request.getAttribute(name));
        }
        return null;
    }

    public static void setAttribute(String name, Object o) {
        HttpServletRequest request = WebUtil.request();
        if (request != null) {
            request.setAttribute(name, o);
        }
    }

    private static ServletRequestAttributes attributes() {
        RequestAttributes attributes = RequestContextHolder.getRequestAttributes();
        return (ServletRequestAttributes)attributes;
    }

    public static String getBodyString(ServletRequest request) {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader reader = request.getReader();){
            String line;
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (IOException e) {
            log.error("getBodyString\u51fa\u73b0\u95ee\u9898\uff01", (Throwable)e);
        }
        return sb.toString();
    }

    public static String getUrl() {
        HttpServletRequest request = WebUtil.request();
        if (request != null) {
            return WebUtil.getDomain(request);
        }
        return null;
    }

    public static String getDomain(HttpServletRequest request) {
        StringBuffer url = request.getRequestURL();
        String contextPath = request.getServletContext().getContextPath();
        return url.delete(url.length() - request.getRequestURI().length(), url.length()).append(contextPath).toString();
    }
}

