/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.sql.config;

import cn.sinozg.applet.common.properties.AppValue;
import cn.sinozg.applet.sql.SpySqlLogger;
import com.p6spy.engine.spy.P6DataSource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;

/**
 * @author xieyubin
 * @Description
 * @Copyright Copyright (c) 2025
 * @since 2025-07-17 00:24
 */
@Configuration
@ConditionalOnClass(P6DataSource.class)
@ConditionalOnProperty(prefix = "app.spy", name = "enabled", havingValue = "true")
public class SpyAutoConfiguration {

    public SpyAutoConfiguration(AppValue appValue) {
        SpySqlLogger.init(appValue.getSpy());
    }
}
