/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.sql;

import cn.sinozg.applet.common.properties.SpyValue;
import com.p6spy.engine.common.P6Util;
import com.p6spy.engine.logging.Category;
import com.p6spy.engine.spy.appender.FormattedLogger;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author xyb
 * @Description
 * @Copyright Copyright (c) 2024
 * @since 2024-08-16 17:21
 */
public class SpySqlLogger extends FormattedLogger {

    private static final String SQL = " TIME: {}ms, SQL: {}";

    private static SpyValue spy;

    private static final Logger log = LoggerFactory.getLogger(SpySqlLogger.class);

    public static void init (SpyValue spy){
        SpySqlLogger.spy = spy;
    }

    @Override
    public void logException(Exception e) {
        log.error(StringUtils.EMPTY, e);
    }

    @Override
    public void logText(String text) {
    }

    @Override
    public void logSQL(int connectionId, String now, long elapsed, Category category, String prepared, String sql, String url) {
        if (spy == null) {
            return;
        }
        if (spy.getSlowThreshold() > 0 && elapsed > spy.getSlowThreshold()) {
            log.error(SQL, elapsed, P6Util.singleLine(sql));
        } else if (spy.isLogAll()) {
            log.info(SQL, elapsed, P6Util.singleLine(sql));
        }
    }

    @Override
    public boolean isCategoryEnabled(Category category) {
        if (Category.ERROR.equals(category)) {
            return log.isErrorEnabled();
        } else if (Category.WARN.equals(category)) {
            return log.isWarnEnabled();
        } else if (Category.DEBUG.equals(category)) {
            return log.isDebugEnabled();
        } else {
            return log.isInfoEnabled();
        }
    }
}
