/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.sql;

import cn.sinozg.applet.common.properties.SpyValue;
import com.p6spy.engine.common.P6Util;
import com.p6spy.engine.logging.Category;
import com.p6spy.engine.spy.appender.FormattedLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpySqlLogger
extends FormattedLogger {
    private static final String SQL = " TIME: {}ms, SQL: {}";
    private static SpyValue spy;
    private static final Logger log;

    public static void init(SpyValue spy) {
        SpySqlLogger.spy = spy;
    }

    public void logException(Exception e) {
        log.error("", (Throwable)e);
    }

    public void logText(String text) {
    }

    public void logSQL(int connectionId, String now, long elapsed, Category category, String prepared, String sql, String url) {
        if (spy == null) {
            return;
        }
        if (spy.getSlowThreshold() > 0 && elapsed > (long)spy.getSlowThreshold()) {
            log.error(SQL, (Object)elapsed, (Object)P6Util.singleLine((String)sql));
        } else if (spy.isLogAll()) {
            log.info(SQL, (Object)elapsed, (Object)P6Util.singleLine((String)sql));
        }
    }

    public boolean isCategoryEnabled(Category category) {
        if (Category.ERROR.equals((Object)category)) {
            return log.isErrorEnabled();
        }
        if (Category.WARN.equals((Object)category)) {
            return log.isWarnEnabled();
        }
        if (Category.DEBUG.equals((Object)category)) {
            return log.isDebugEnabled();
        }
        return log.isInfoEnabled();
    }

    static {
        log = LoggerFactory.getLogger(SpySqlLogger.class);
    }
}

