package cn.sinozg.applet.biz.tenant.scheduled;

import cn.sinozg.applet.biz.tenant.service.TenantLicenseService;
import cn.sinozg.applet.common.properties.AppValue;
import cn.sinozg.applet.common.runner.BaseScheduling;
import jakarta.annotation.Resource;
import org.springframework.stereotype.Component;

/**
 * 租户刷新
 * @author xyb
 * @Description
 * @Copyright Copyright (c) 2024
 * @since 2024-11-03 13:28
 */
@Component
public class TenantCacheRefresh extends BaseScheduling {

    @Resource
    private AppValue app;

    @Resource
    private TenantLicenseService tenantLicenseService;

    @Override
    public void setParams() {
        this.cron = "0 0 1 * * ?";
        this.clazz = TenantCacheRefresh.class;
    }

    @Override
    public void execute() {
        if (app.getTenant().isEnable()) {
            tenantLicenseService.refreshTenantCache();
        }
    }
}
