package cn.sinozg.applet.biz.tenant.util;

import cn.sinozg.applet.biz.tenant.vo.model.TenantInfoCache;
import cn.sinozg.applet.common.constant.BaseRedisKeys;
import cn.sinozg.applet.common.utils.RedisUtil;
import cn.sinozg.applet.common.utils.UserUtil;
import org.apache.commons.lang3.StringUtils;

/**
 * 租户工具类
 * @author xyb
 * @Description
 * @Copyright Copyright (c) 2024
 * @since 2024-11-03 16:38
 */
public class TenantUtil {

    /**
     * 租户权限 是否有
     * @return 租户是否有权限
     */
    public static boolean allow() {
        return allow(null);
    }

    /**
     * 租户权限 是否有
     * @param tenantId 租户id
     * @return 租户是否有权限
     */
    public static boolean allow(String tenantId) {
        if (StringUtils.isBlank(tenantId)) {
            tenantId = UserUtil.tenantId();
        }
        if (StringUtils.isNotBlank(tenantId)) {
            TenantInfoCache tenant = RedisUtil.getCacheObject(String.format(BaseRedisKeys.CORP, tenantId));
            return tenant != null;
        }
        return false;
    }
}
