package cn.sinozg.applet.biz.tenant.vo.model;

import io.swagger.v3.oas.annotations.media.Schema;
import java.time.LocalDateTime;

/**
 * 租户信息
 * @author xyb
 * @Description
 * @Copyright Copyright (c) 2024
 * @since 2024-11-03 13:19
 */
public class TenantInfoCache {
    /** 主键id */
    @Schema(description = "主键id")
    private String id;

    /** 租户id */
    @Schema(description = "租户id")
    private String tenantId;

    /** 租户名称 */
    @Schema(description = "租户名称")
    private String corpName;

    /** 联系人 */
    @Schema(description = "联系人")
    private String liaison;

    /** 联系电话 */
    @Schema(description = "联系电话")
    private String phoneNum;

    /** 邮箱地址 */
    @Schema(description = "邮箱地址")
    private String email;

    /** 联系地址 */
    @Schema(description = "联系地址")
    private String address;

    /** 到期日期 */
    @Schema(description = "到期日期")
    private LocalDateTime expireDate;


    /**
     * 获取 主键id
     *
     * @return id 主键id
     */
    public String getId() {
        return this.id;
    }

    /**
     * 设置 主键id
     *
     * @param id 主键id
     */
    public void setId(String id) {
        this.id = id;
    }

    /**
     * 获取 租户id
     *
     * @return tenantId 租户id
     */
    public String getTenantId() {
        return this.tenantId;
    }

    /**
     * 设置 租户id
     *
     * @param tenantId 租户id
     */
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    /**
     * 获取 租户名称
     *
     * @return corpName 租户名称
     */
    public String getCorpName() {
        return this.corpName;
    }

    /**
     * 设置 租户名称
     *
     * @param corpName 租户名称
     */
    public void setCorpName(String corpName) {
        this.corpName = corpName;
    }

    /**
     * 获取 联系人
     *
     * @return liaison 联系人
     */
    public String getLiaison() {
        return this.liaison;
    }

    /**
     * 设置 联系人
     *
     * @param liaison 联系人
     */
    public void setLiaison(String liaison) {
        this.liaison = liaison;
    }

    /**
     * 获取 联系电话
     *
     * @return phoneNum 联系电话
     */
    public String getPhoneNum() {
        return this.phoneNum;
    }

    /**
     * 设置 联系电话
     *
     * @param phoneNum 联系电话
     */
    public void setPhoneNum(String phoneNum) {
        this.phoneNum = phoneNum;
    }

    /**
     * 获取 邮箱地址
     *
     * @return email 邮箱地址
     */
    public String getEmail() {
        return this.email;
    }

    /**
     * 设置 邮箱地址
     *
     * @param email 邮箱地址
     */
    public void setEmail(String email) {
        this.email = email;
    }

    /**
     * 获取 联系地址
     *
     * @return address 联系地址
     */
    public String getAddress() {
        return this.address;
    }

    /**
     * 设置 联系地址
     *
     * @param address 联系地址
     */
    public void setAddress(String address) {
        this.address = address;
    }

    /**
     * 获取 到期日期
     *
     * @return expireDate 到期日期
     */
    public LocalDateTime getExpireDate() {
        return this.expireDate;
    }

    /**
     * 设置 到期日期
     *
     * @param expireDate 到期日期
     */
    public void setExpireDate(LocalDateTime expireDate) {
        this.expireDate = expireDate;
    }
}
