package cn.sinozg.applet.common.interceptor;

import cn.sinozg.applet.biz.tenant.util.TenantUtil;
import cn.sinozg.applet.common.utils.MsgUtil;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

/**
 * 租户许可 拦截器
 * 租户没有权限的 直接拦截
 * @author xyb
 * @Description
 * @Copyright Copyright (c) 2024
 * @since 2024-11-03 12:22
 */
@Component
public class TenantLicenseInterceptor implements HandlerInterceptor {

    @Override
    public boolean preHandle(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull Object handler) throws Exception {
        if (!TenantUtil.allow()) {
            MsgUtil.httpError(response, request, null, HttpStatus.OK, "BIZ000100035");
            return false;
        }
        return true;
    }
}
