/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.biz.tenant.util;

import cn.sinozg.applet.biz.tenant.vo.model.TenantInfoCache;
import cn.sinozg.applet.common.constant.BaseRedisKeys;
import cn.sinozg.applet.common.utils.RedisUtil;
import cn.sinozg.applet.common.utils.UserUtil;
import org.apache.commons.lang3.StringUtils;

/**
 * 租户工具类
 * @author xyb
 * @Description
 * @Copyright Copyright (c) 2024
 * @since 2024-11-03 16:38
 */
public class TenantUtil {

    /**
     * 租户权限 是否有
     * @return 租户是否有权限
     */
    public static boolean allow() {
        return allow(null);
    }

    /**
     * 租户权限 是否有
     * @param tenantId 租户id
     * @return 租户是否有权限
     */
    public static boolean allow(String tenantId) {
        if (StringUtils.isBlank(tenantId)) {
            tenantId = UserUtil.tenantId();
        }
        if (StringUtils.isNotBlank(tenantId)) {
            TenantInfoCache tenant = RedisUtil.getCacheObject(String.format(BaseRedisKeys.CORP, tenantId));
            return tenant != null;
        }
        return false;
    }
}
