/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.biz.tenant.service.impl;

import cn.sinozg.applet.biz.tenant.service.TenantLicenseService;
import cn.sinozg.applet.biz.tenant.vo.model.TenantInfoCache;
import cn.sinozg.applet.common.constant.BaseConstants;
import cn.sinozg.applet.common.constant.BaseRedisKeys;
import cn.sinozg.applet.common.utils.DateUtil;
import cn.sinozg.applet.common.utils.RedisUtil;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.ImmutableTriple;

/**
 * @author xyb
 * @Description
 * @Copyright Copyright (c) 2024
 * @since 2024-11-03 13:56
 */
public abstract class BaseTenantLicenseService implements TenantLicenseService {

    @Override
    public void refreshTenantCache() {
        List<TenantInfoCache> tenantList = tenantByDb();
        List<ImmutableTriple<String, Long, TenantInfoCache>> list = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(tenantList)) {
            LocalDateTime ldt;
            // 1天内
            LocalDateTime nextDay = LocalDateTime.now().plusDays(1);
            for (TenantInfoCache corpInfo : tenantList) {
                long time = Duration.ofDays(2).toSeconds();
                ldt = corpInfo.getExpireDate();
                if (ldt != null && ldt.isBefore(nextDay)) {
                    // 设置过期时间
                    time = DateUtil.diffSeconds(LocalDateTime.now(), ldt);
                }
                list.add(ImmutableTriple.of(corpInfo.getTenantId(), time, corpInfo));
            }
        }
        Collection<String> keys = RedisUtil.keys(String.format(BaseRedisKeys.CORP, BaseConstants.ALL));
        list.forEach(p -> {
            String key = String.format(BaseRedisKeys.CORP, p.getLeft());
            RedisUtil.setCacheObject(key, p.getRight(), p.getMiddle());
            keys.remove(key);
        });
        if (CollectionUtils.isNotEmpty(keys)) {
            RedisUtil.deleteObject(keys);
        }
    }

    @Override
    public List<TenantInfoCache> tenantByDb() {
        return null;
    }
}
