/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.common.handler;

import cn.sinozg.applet.common.core.model.UserThreadInfo;
import cn.sinozg.applet.common.holder.UserContextHolder;
import cn.sinozg.applet.common.properties.TenantValue;
import com.baomidou.mybatisplus.extension.plugins.handler.TenantLineHandler;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.StringValue;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 多租户 配置
 * @Author: xyb
 * @Description:
 * @Date: 2022-11-26 下午 04:41
 **/
public class TenantHandler implements TenantLineHandler {

    private final Logger log = LoggerFactory.getLogger(TenantHandler.class);

    private final TenantValue tenantValue;

    public TenantHandler(final TenantValue tenantValue) {
        this.tenantValue = tenantValue;
    }

    @Override
    public Expression getTenantId() {
        UserThreadInfo info = UserContextHolder.getInfo();
        if (info == null) {
            if (log.isWarnEnabled()) {
                log.warn("租户信息为空！");
            }
            return new StringValue();
        }
        return new StringValue(info.getTenantId());
    }

    @Override
    public boolean ignoreTable(String tableName) {
        List<String> tenantTables = tenantValue.getTables();
        return CollectionUtils.isEmpty(tenantTables) || CollectionUtils.containsAny(tenantTables, tableName.toLowerCase());
    }
}