/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.biz.tenant.service.impl;

import cn.sinozg.applet.biz.tenant.service.TenantLicenseService;
import cn.sinozg.applet.biz.tenant.vo.model.TenantInfoCache;
import cn.sinozg.applet.common.utils.DateUtil;
import cn.sinozg.applet.common.utils.RedisUtil;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.ImmutableTriple;

public abstract class BaseTenantLicenseService
implements TenantLicenseService {
    @Override
    public void refreshTenantCache() {
        List<TenantInfoCache> tenantList = this.tenantByDb();
        ArrayList<ImmutableTriple> list = new ArrayList<ImmutableTriple>();
        if (CollectionUtils.isNotEmpty(tenantList)) {
            LocalDateTime nextDay = LocalDateTime.now().plusDays(1L);
            for (TenantInfoCache corpInfo : tenantList) {
                long time = Duration.ofDays(2L).toSeconds();
                LocalDateTime ldt = corpInfo.getExpireDate();
                if (ldt != null && ldt.isBefore(nextDay)) {
                    time = DateUtil.diffSeconds((LocalDateTime)LocalDateTime.now(), (LocalDateTime)ldt);
                }
                list.add(ImmutableTriple.of((Object)corpInfo.getTenantId(), (Object)time, (Object)corpInfo));
            }
        }
        Collection keys = RedisUtil.keys((String)String.format("jby:biz:corp:%s", "*"));
        list.forEach(p -> {
            String key = String.format("jby:biz:corp:%s", p.getLeft());
            RedisUtil.setCacheObject((String)key, (Object)((TenantInfoCache)p.getRight()), (long)((Long)p.getMiddle()));
            keys.remove(key);
        });
        if (CollectionUtils.isNotEmpty((Collection)keys)) {
            RedisUtil.deleteObject((Collection)keys);
        }
    }

    @Override
    public List<TenantInfoCache> tenantByDb() {
        return null;
    }
}

