/*
 * Decompiled with CFR 0.152.
 */
package cn.sinozg.applet.common.service.impl;

import cn.sinozg.applet.common.interceptor.TenantLicenseInterceptor;
import cn.sinozg.applet.common.properties.ApiUrlValue;
import cn.sinozg.applet.common.properties.AppValue;
import cn.sinozg.applet.common.properties.TenantValue;
import cn.sinozg.applet.common.service.FrameworkTenantService;
import cn.sinozg.applet.common.service.impl.TenantHandler;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.handler.TenantLineHandler;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.TenantLineInnerInterceptor;
import jakarta.annotation.Resource;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;

@Service
public class FrameworkTenantServiceImpl
implements FrameworkTenantService {
    @Resource
    private AppValue app;
    @Resource
    private TenantLicenseInterceptor tenantLicenseInterceptor;
    private static final Logger log = LoggerFactory.getLogger(FrameworkTenantServiceImpl.class);

    public void dbInterceptor(MybatisPlusInterceptor interceptor) {
        TenantValue tenant = this.app.getTenant();
        if (tenant.isEnable()) {
            log.info("\u5f00\u542f\u4e86\u591a\u79df\u6237\u6a21\u5f0f\uff0c\u52a0\u8f7d\u591a\u79df\u6237Interceptor\uff01");
            TenantLineInnerInterceptor tenantInner = new TenantLineInnerInterceptor((TenantLineHandler)new TenantHandler(tenant));
            interceptor.addInnerInterceptor((InnerInterceptor)tenantInner);
        }
    }

    public void expiredCheckInterceptor(InterceptorRegistry registry) {
        TenantValue tenant = this.app.getTenant();
        if (tenant.isEnable() && tenant.isExpiredCheck()) {
            ApiUrlValue apiUrl = this.app.getApiUrl();
            if (CollectionUtils.isEmpty((Collection)apiUrl.getParamsPatterns())) {
                log.error("\u8bf7\u5148\u8bbe\u7f6e\u8bf7\u6c42\u62e6\u622a: app.apiUrl.paramsPatterns");
                return;
            }
            List excludePath = apiUrl.getAuthExcludePath();
            if (CollectionUtils.isNotEmpty((Collection)tenant.getCheckExcludePath())) {
                excludePath.addAll(tenant.getCheckExcludePath());
            }
            log.info("\u5f00\u542f\u4e86\u591a\u79df\u6237\u6388\u6743\u68c0\u6d4b\u6a21\u5f0f\uff0c\u52a0\u8f7d\u591a\u79df\u6237InterceptorRegistry\uff01");
            registry.addInterceptor((HandlerInterceptor)this.tenantLicenseInterceptor).addPathPatterns(apiUrl.getAuthPatterns()).excludePathPatterns(excludePath);
        }
    }
}

