/*
 * Copyright (C) 2020-2024, Xie YuBin
 * The GNU Free Documentation License covers this file. The original version
 * of this license can be found at http://www.gnu.org/licenses/gfdl.html.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Free Documentation License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Free Documentation License for more details.
 *
 * You should have received a copy of the GNU Free Documentation License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package cn.sinozg.applet.common.interceptor;

import cn.sinozg.applet.biz.tenant.util.TenantUtil;
import cn.sinozg.applet.common.core.model.ErrorMsgInfo;
import cn.sinozg.applet.common.utils.MsgUtil;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

/**
 * 租户许可 拦截器
 * 租户没有权限的 直接拦截
 * @author xyb
 * @Description
 * @Copyright Copyright (c) 2024
 * @since 2024-11-03 12:22
 */
@Component
public class TenantLicenseInterceptor implements HandlerInterceptor {

    @Override
    public boolean preHandle(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull Object handler) throws Exception {
        if (!TenantUtil.allow()) {
            MsgUtil.httpOkError(new ErrorMsgInfo.Builder("BIZ000100035", request, response));
            return false;
        }
        return true;
    }
}
