package cn.sinozg.applet.biz.system.vo.request;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

/**
 * 发送小程序信息
 * @Author: xyb
 * @Description:
 * @Date: 2023-03-23 下午 05:45
 **/
public class TencentMessageRequest {

    /** 小程序的原始ID */
    @JsonProperty(value = "ToUserName")
    @Schema(description = "小程序的原始ID")
    private String toUserName;
    /** 发送者的openid */
    @JsonProperty(value = "FromUserName")
    @Schema(description = "发送者的openid")
    private String fromUserName;
    /** 消息创建时间(整型） */
    @JsonProperty(value = "CreateTime")
    @Schema(description = "消息创建时间(整型）")
    private long createTime;
    /** 消息类型 */
    @JsonProperty(value = "MsgType")
    @Schema(description = "消息类型")
    private String msgType;
    /** 文本消息内容 */
    @JsonProperty(value = "Content")
    @Schema(description = "文本消息内容")
    private String content;
    /** 图片链接（由系统生成） */
    @JsonProperty(value = "PicUrl")
    @Schema(description = "图片链接")
    private String picUrl;
    /** 图片消息媒体id，可以调用[获取临时素材]((getTempMedia)接口拉取数据。 */
    @JsonProperty(value = "MediaId")
    @Schema(description = "图片消息媒体id，可以调用[获取临时素材]((getTempMedia)接口拉取数据")
    private String mediaId;
    /** 标题 */
    @JsonProperty(value = "Title")
    @Schema(description = "标题")
    private String title;
    /** 小程序appid */
    @JsonProperty(value = "AppId")
    @Schema(description = "小程序appid")
    private String appId;
    /** 小程序页面路径 */
    @JsonProperty(value = "PagePath")
    @Schema(description = "小程序页面路径")
    private String pagePath;
    /** 封面图片的临时cdn链接 */
    @JsonProperty(value = "ThumbUrl")
    @Schema(description = "封面图片的临时cdn链接")
    private String thumbUrl;
    /** 封面图片的临时素材id */
    @JsonProperty(value = "ThumbMediaId")
    @Schema(description = "封面图片的临时素材id")
    private String thumbMediaId;
    /** 消息id，64位整型 */
    @JsonProperty(value = "MsgId")
    @Schema(description = "消息id")
    private long msgId;
    /** 事件类型，user_enter_tempsession */
    @JsonProperty(value = "Event")
    @Schema(description = "事件类型")
    private String event;
    /** session-from 属性 */
    @JsonProperty(value = "SessionFrom")
    @Schema(description = "session-from 属性")
    private String sessionFrom;

    /**
     * 获取 小程序的原始ID
     *
     * @return toUserName 小程序的原始ID
     */
    public String getToUserName() {
        return this.toUserName;
    }

    /**
     * 设置 小程序的原始ID
     *
     * @param toUserName 小程序的原始ID
     */
    public void setToUserName(String toUserName) {
        this.toUserName = toUserName;
    }

    /**
     * 获取 发送者的openid
     *
     * @return fromUserName 发送者的openid
     */
    public String getFromUserName() {
        return this.fromUserName;
    }

    /**
     * 设置 发送者的openid
     *
     * @param fromUserName 发送者的openid
     */
    public void setFromUserName(String fromUserName) {
        this.fromUserName = fromUserName;
    }

    /**
     * 获取 消息创建时间(整型）
     *
     * @return createTime 消息创建时间(整型）
     */
    public long getCreateTime() {
        return this.createTime;
    }

    /**
     * 设置 消息创建时间(整型）
     *
     * @param createTime 消息创建时间(整型）
     */
    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    /**
     * 获取 消息类型
     *
     * @return msgType 消息类型
     */
    public String getMsgType() {
        return this.msgType;
    }

    /**
     * 设置 消息类型
     *
     * @param msgType 消息类型
     */
    public void setMsgType(String msgType) {
        this.msgType = msgType;
    }

    /**
     * 获取 文本消息内容
     *
     * @return content 文本消息内容
     */
    public String getContent() {
        return this.content;
    }

    /**
     * 设置 文本消息内容
     *
     * @param content 文本消息内容
     */
    public void setContent(String content) {
        this.content = content;
    }

    /**
     * 获取 图片链接（由系统生成）
     *
     * @return picUrl 图片链接（由系统生成）
     */
    public String getPicUrl() {
        return this.picUrl;
    }

    /**
     * 设置 图片链接（由系统生成）
     *
     * @param picUrl 图片链接（由系统生成）
     */
    public void setPicUrl(String picUrl) {
        this.picUrl = picUrl;
    }

    /**
     * 获取 图片消息媒体id，可以调用[获取临时素材]((getTempMedia)接口拉取数据。
     *
     * @return mediaId 图片消息媒体id，可以调用[获取临时素材]((getTempMedia)接口拉取数据。
     */
    public String getMediaId() {
        return this.mediaId;
    }

    /**
     * 设置 图片消息媒体id，可以调用[获取临时素材]((getTempMedia)接口拉取数据。
     *
     * @param mediaId 图片消息媒体id，可以调用[获取临时素材]((getTempMedia)接口拉取数据。
     */
    public void setMediaId(String mediaId) {
        this.mediaId = mediaId;
    }

    /**
     * 获取 标题
     *
     * @return title 标题
     */
    public String getTitle() {
        return this.title;
    }

    /**
     * 设置 标题
     *
     * @param title 标题
     */
    public void setTitle(String title) {
        this.title = title;
    }

    /**
     * 获取 小程序appid
     *
     * @return appId 小程序appid
     */
    public String getAppId() {
        return this.appId;
    }

    /**
     * 设置 小程序appid
     *
     * @param appId 小程序appid
     */
    public void setAppId(String appId) {
        this.appId = appId;
    }

    /**
     * 获取 小程序页面路径
     *
     * @return pagePath 小程序页面路径
     */
    public String getPagePath() {
        return this.pagePath;
    }

    /**
     * 设置 小程序页面路径
     *
     * @param pagePath 小程序页面路径
     */
    public void setPagePath(String pagePath) {
        this.pagePath = pagePath;
    }

    /**
     * 获取 封面图片的临时cdn链接
     *
     * @return thumbUrl 封面图片的临时cdn链接
     */
    public String getThumbUrl() {
        return this.thumbUrl;
    }

    /**
     * 设置 封面图片的临时cdn链接
     *
     * @param thumbUrl 封面图片的临时cdn链接
     */
    public void setThumbUrl(String thumbUrl) {
        this.thumbUrl = thumbUrl;
    }

    /**
     * 获取 封面图片的临时素材id
     *
     * @return thumbMediaId 封面图片的临时素材id
     */
    public String getThumbMediaId() {
        return this.thumbMediaId;
    }

    /**
     * 设置 封面图片的临时素材id
     *
     * @param thumbMediaId 封面图片的临时素材id
     */
    public void setThumbMediaId(String thumbMediaId) {
        this.thumbMediaId = thumbMediaId;
    }

    /**
     * 获取 消息id，64位整型
     *
     * @return msgId 消息id，64位整型
     */
    public long getMsgId() {
        return this.msgId;
    }

    /**
     * 设置 消息id，64位整型
     *
     * @param msgId 消息id，64位整型
     */
    public void setMsgId(long msgId) {
        this.msgId = msgId;
    }

    /**
     * 获取 事件类型，user_enter_tempsession
     *
     * @return event 事件类型，user_enter_tempsession
     */
    public String getEvent() {
        return this.event;
    }

    /**
     * 设置 事件类型，user_enter_tempsession
     *
     * @param event 事件类型，user_enter_tempsession
     */
    public void setEvent(String event) {
        this.event = event;
    }

    /**
     * 获取 session-from 属性
     *
     * @return sessionFrom session-from 属性
     */
    public String getSessionFrom() {
        return this.sessionFrom;
    }

    /**
     * 设置 session-from 属性
     *
     * @param sessionFrom session-from 属性
     */
    public void setSessionFrom(String sessionFrom) {
        this.sessionFrom = sessionFrom;
    }
}