package cn.sinozg.applet.biz.system.vo.request;

import io.swagger.v3.oas.annotations.media.Schema;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;


/**
* 退款申请单参数
* @Author: xyb
* @Description: 
* @Date: 2023-03-24 下午 11:40
**/
public class WebRefundRequest {

    /** 微信订单号 */
    @Schema(description = "微信订单号")
    private String transactionId;

    /** 退款订单 */
    @NotBlank(message = "{TIRSCI.WebRefundRequest.refundNo}")
    @Schema(description = "退款订单")
    private String refundNo;

    /** 订单金额  */
    @NotEmpty(message = "{TIRSCI.WebRefundRequest.totalFee}")
    @Schema(description = "订单金额")
    private int totalFee;

    /** 退款金额  */
    @NotEmpty(message = "{TIRSCI.WebRefundRequest.refundFee}")
    @Schema(description = "退款金额")
    private int refundFee;

    /** 退款原因  */
    @Schema(description = "退款原因")
    private String refundDesc;

    /**
     * 获取 微信订单号
     *
     * @return transactionId 微信订单号
     */
    public String getTransactionId() {
        return this.transactionId;
    }

    /**
     * 设置 微信订单号
     *
     * @param transactionId 微信订单号
     */
    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    /**
     * 获取 退款订单
     *
     * @return refundNo 退款订单
     */
    public String getRefundNo() {
        return this.refundNo;
    }

    /**
     * 设置 退款订单
     *
     * @param refundNo 退款订单
     */
    public void setRefundNo(String refundNo) {
        this.refundNo = refundNo;
    }

    /**
     * 获取 订单金额
     *
     * @return totalFee 订单金额
     */
    public int getTotalFee() {
        return this.totalFee;
    }

    /**
     * 设置 订单金额
     *
     * @param totalFee 订单金额
     */
    public void setTotalFee(int totalFee) {
        this.totalFee = totalFee;
    }

    /**
     * 获取 退款金额
     *
     * @return refundFee 退款金额
     */
    public int getRefundFee() {
        return this.refundFee;
    }

    /**
     * 设置 退款金额
     *
     * @param refundFee 退款金额
     */
    public void setRefundFee(int refundFee) {
        this.refundFee = refundFee;
    }

    /**
     * 获取 退款原因
     *
     * @return refundDesc 退款原因
     */
    public String getRefundDesc() {
        return this.refundDesc;
    }

    /**
     * 设置 退款原因
     *
     * @param refundDesc 退款原因
     */
    public void setRefundDesc(String refundDesc) {
        this.refundDesc = refundDesc;
    }
}