package cn.sinozg.applet.biz.system.vo.request;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
* 请求微信支付接口请求封装对象
 * 金额
* @Author: xyb
* @Description: 
* @Date: 2023-03-24 下午 09:46
**/
public class OrderRefundAmount {
    /**
     * 订单总金额，单位为分
     */
    @JsonProperty(value = "total")
    private int total;
    /**
     * 退款金额，单位为分
     */
    @JsonProperty(value = "refund")
    private int refund;
    /**
     * CNY：人民币，境内商户号仅支持人民币。
     */
    @JsonProperty(value = "currency")
    private String currency = "CNY";
    /**
     * 退款出资账户及金额
     */
    @JsonProperty(value = "from")
    private List<OrderRefundAmountFrom> from;

    /**
     * 获取 订单总金额，单位为分
     *
     * @return total 订单总金额，单位为分
     */
    public int getTotal() {
        return this.total;
    }

    /**
     * 设置 订单总金额，单位为分
     *
     * @param total 订单总金额，单位为分
     */
    public void setTotal(int total) {
        this.total = total;
    }

    /**
     * 获取 退款金额，单位为分
     *
     * @return refund 退款金额，单位为分
     */
    public int getRefund() {
        return this.refund;
    }

    /**
     * 设置 退款金额，单位为分
     *
     * @param refund 退款金额，单位为分
     */
    public void setRefund(int refund) {
        this.refund = refund;
    }

    /**
     * 获取 CNY：人民币，境内商户号仅支持人民币。
     *
     * @return currency CNY：人民币，境内商户号仅支持人民币。
     */
    public String getCurrency() {
        return this.currency;
    }

    /**
     * 设置 CNY：人民币，境内商户号仅支持人民币。
     *
     * @param currency CNY：人民币，境内商户号仅支持人民币。
     */
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    /**
     * 获取 退款出资账户及金额
     *
     * @return from 退款出资账户及金额
     */
    public List<OrderRefundAmountFrom> getFrom() {
        return this.from;
    }

    /**
     * 设置 退款出资账户及金额
     *
     * @param from 退款出资账户及金额
     */
    public void setFrom(List<OrderRefundAmountFrom> from) {
        this.from = from;
    }
}
