package cn.sinozg.applet.biz.system.vo.request;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;

/**
 * 接收小程序
 * @Author: xyb
 * @Description:
 * @Date: 2023-03-23 下午 05:45
 **/
public class TencentServiceRequest {

    /** 验证的消息 */
    @NotBlank(message = "{TIRSCI.TencentServiceRequest.echostr}")
    @Schema(description = "验证的消息")
    private String echostr;

    /** 加密后的信息 */
    @NotBlank(message = "{TIRSCI.TencentServiceRequest.signature}")
    @Schema(description = "加密后的信息")
    private String signature;

    /** 时间戳 */
    @NotBlank(message = "{TIRSCI.TencentServiceRequest.timestamp}")
    @Schema(description = "时间戳")
    private String timestamp;

    /** 随机数 */
    @NotBlank(message = "{TIRSCI.TencentServiceRequest.nonce}")
    @Schema(description = "随机数")
    private String nonce;

    /**
     * 获取 验证的消息
     *
     * @return echostr 验证的消息
     */
    public String getEchostr() {
        return this.echostr;
    }

    /**
     * 设置 验证的消息
     *
     * @param echostr 验证的消息
     */
    public void setEchostr(String echostr) {
        this.echostr = echostr;
    }

    /**
     * 获取 加密后的信息
     *
     * @return signature 加密后的信息
     */
    public String getSignature() {
        return this.signature;
    }

    /**
     * 设置 加密后的信息
     *
     * @param signature 加密后的信息
     */
    public void setSignature(String signature) {
        this.signature = signature;
    }

    /**
     * 获取 时间戳
     *
     * @return timestamp 时间戳
     */
    public String getTimestamp() {
        return this.timestamp;
    }

    /**
     * 设置 时间戳
     *
     * @param timestamp 时间戳
     */
    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    /**
     * 获取 随机数
     *
     * @return nonce 随机数
     */
    public String getNonce() {
        return this.nonce;
    }

    /**
     * 设置 随机数
     *
     * @param nonce 随机数
     */
    public void setNonce(String nonce) {
        this.nonce = nonce;
    }
}
